/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.zza;
import com.google.android.gms.games.internal.zzc;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;

public final class EventEntity
extends zzc
implements Event {
    public static final Parcelable.Creator<EventEntity> CREATOR = new zza();
    private final String zzhwp;
    private final String mName;
    private final String zzdxh;
    private final Uri zzhra;
    private final String zzhrl;
    private final PlayerEntity zzhwk;
    private final long zzdxg;
    private final String zzhwq;
    private final boolean zzawi;

    public EventEntity(Event event) {
        this.zzhwp = event.getEventId();
        this.mName = event.getName();
        this.zzdxh = event.getDescription();
        this.zzhra = event.getIconImageUri();
        this.zzhrl = event.getIconImageUrl();
        this.zzhwk = (PlayerEntity)event.getPlayer().freeze();
        this.zzdxg = event.getValue();
        this.zzhwq = event.getFormattedValue();
        this.zzawi = event.isVisible();
    }

    EventEntity(String string, String string2, String string3, Uri uri, String string4, Player player, long l, String string5, boolean bl) {
        this.zzhwp = string;
        this.mName = string2;
        this.zzdxh = string3;
        this.zzhra = uri;
        this.zzhrl = string4;
        this.zzhwk = new PlayerEntity(player);
        this.zzdxg = l;
        this.zzhwq = string5;
        this.zzawi = bl;
    }

    @Override
    public final String getEventId() {
        return this.zzhwp;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzdxh;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzdxh, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zzhra;
    }

    @Override
    public final String getIconImageUrl() {
        return this.zzhrl;
    }

    @Override
    public final Player getPlayer() {
        return this.zzhwk;
    }

    @Override
    public final long getValue() {
        return this.zzdxg;
    }

    @Override
    public final String getFormattedValue() {
        return this.zzhwq;
    }

    @Override
    public final void getFormattedValue(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzhwq, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final boolean isVisible() {
        return this.zzawi;
    }

    public final Event freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return Arrays.hashCode(new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public final boolean equals(Object object) {
        return EventEntity.zza(this, object);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzbg.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzbg.equal((Object)event2.getName(), (Object)event.getName()) && zzbg.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzbg.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzbg.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzbg.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzbg.equal((Object)event2.getValue(), (Object)event.getValue()) && zzbg.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzbg.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public final String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzbg.zzx((Object)event).zzg("Id", (Object)event.getEventId()).zzg("Name", (Object)event.getName()).zzg("Description", (Object)event.getDescription()).zzg("IconImageUri", (Object)event.getIconImageUri()).zzg("IconImageUrl", (Object)event.getIconImageUrl()).zzg("Player", (Object)event.getPlayer()).zzg("Value", (Object)event.getValue()).zzg("FormattedValue", (Object)event.getFormattedValue()).zzg("isVisible", (Object)event.isVisible()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        EventEntity eventEntity = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (String)eventEntity.getEventId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)eventEntity.getName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (String)eventEntity.getDescription(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)eventEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (String)eventEntity.getIconImageUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (Parcelable)eventEntity.getPlayer(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (long)eventEntity.getValue());
        zzbgo.zza((Parcel)parcel2, (int)8, (String)eventEntity.getFormattedValue(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)9, (boolean)eventEntity.isVisible());
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }
}

