/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.zzc;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Deprecated
public final class QuestEntity
extends com.google.android.gms.games.internal.zzc
implements Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new zzc();
    private final GameEntity zzibx;
    private final String zzigv;
    private final long zzigw;
    private final Uri zzigx;
    private final String zzigy;
    private final String zzdxh;
    private final long zzigz;
    private final long zzhwn;
    private final Uri zziha;
    private final String zzihb;
    private final String mName;
    private final long zzihc;
    private final long zzihd;
    private final int mState;
    private final int zzenu;
    private final ArrayList<MilestoneEntity> zzihe;

    @Hide
    public QuestEntity(Quest quest) {
        this.zzibx = new GameEntity(quest.getGame());
        this.zzigv = quest.getQuestId();
        this.zzigw = quest.getAcceptedTimestamp();
        this.zzdxh = quest.getDescription();
        this.zzigx = quest.getBannerImageUri();
        this.zzigy = quest.getBannerImageUrl();
        this.zzigz = quest.getEndTimestamp();
        this.zziha = quest.getIconImageUri();
        this.zzihb = quest.getIconImageUrl();
        this.zzhwn = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzihc = quest.zzavx();
        this.zzihd = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzenu = quest.getType();
        List<Milestone> list = quest.zzavw();
        int n = list.size();
        this.zzihe = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzihe.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(GameEntity gameEntity, String string, long l, Uri uri, String string2, String string3, long l2, long l3, Uri uri2, String string4, String string5, long l4, long l5, int n, int n2, ArrayList<MilestoneEntity> arrayList) {
        this.zzibx = gameEntity;
        this.zzigv = string;
        this.zzigw = l;
        this.zzigx = uri;
        this.zzigy = string2;
        this.zzdxh = string3;
        this.zzigz = l2;
        this.zzhwn = l3;
        this.zziha = uri2;
        this.zzihb = string4;
        this.mName = string5;
        this.zzihc = l4;
        this.zzihd = l5;
        this.mState = n;
        this.zzenu = n2;
        this.zzihe = arrayList;
    }

    @Override
    public final String getQuestId() {
        return this.zzigv;
    }

    @Override
    public final String getName() {
        return this.mName;
    }

    @Override
    public final void getName(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final String getDescription() {
        return this.zzdxh;
    }

    @Override
    public final void getDescription(CharArrayBuffer charArrayBuffer) {
        zzh.zzb((String)this.zzdxh, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public final Uri getIconImageUri() {
        return this.zziha;
    }

    @Override
    @Hide
    public final String getIconImageUrl() {
        return this.zzihb;
    }

    @Override
    public final Uri getBannerImageUri() {
        return this.zzigx;
    }

    @Override
    @Hide
    public final String getBannerImageUrl() {
        return this.zzigy;
    }

    @Override
    public final Milestone getCurrentMilestone() {
        return this.zzavw().get(0);
    }

    @Override
    @Hide
    public final List<Milestone> zzavw() {
        return new ArrayList<Milestone>(this.zzihe);
    }

    @Override
    public final Game getGame() {
        return this.zzibx;
    }

    @Override
    public final int getState() {
        return this.mState;
    }

    @Override
    @Hide
    public final int getType() {
        return this.zzenu;
    }

    @Override
    public final long getAcceptedTimestamp() {
        return this.zzigw;
    }

    @Override
    public final long getEndTimestamp() {
        return this.zzigz;
    }

    @Override
    public final long getLastUpdatedTimestamp() {
        return this.zzhwn;
    }

    @Override
    @Hide
    public final long zzavx() {
        return this.zzihc;
    }

    @Override
    public final long getStartTimestamp() {
        return this.zzihd;
    }

    @Override
    public final boolean isEndingSoon() {
        return this.zzihc <= System.currentTimeMillis() + 1800000L;
    }

    public final Quest freeze() {
        return this;
    }

    public final boolean isDataValid() {
        return true;
    }

    public final int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return Arrays.hashCode(new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzavw(), quest.getName(), quest.zzavx(), quest.getStartTimestamp(), quest.getState()});
    }

    public final boolean equals(Object object) {
        return QuestEntity.zza(this, object);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzbg.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzbg.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzbg.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzbg.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzbg.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzbg.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzbg.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzbg.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzbg.equal(quest2.zzavw(), quest.zzavw()) && zzbg.equal((Object)quest2.getName(), (Object)quest.getName()) && zzbg.equal((Object)quest2.zzavx(), (Object)quest.zzavx()) && zzbg.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzbg.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public final String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzbg.zzx((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzavw()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzavx()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        QuestEntity questEntity = this;
        int n2 = zzbgo.zze((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)1, (Parcelable)questEntity.getGame(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)questEntity.getQuestId(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)3, (long)questEntity.getAcceptedTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)4, (Parcelable)questEntity.getBannerImageUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)5, (String)questEntity.getBannerImageUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (String)questEntity.getDescription(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)7, (long)questEntity.getEndTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)8, (long)questEntity.getLastUpdatedTimestamp());
        zzbgo.zza((Parcel)parcel2, (int)9, (Parcelable)questEntity.getIconImageUri(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)10, (String)questEntity.getIconImageUrl(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)12, (String)questEntity.getName(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)13, (long)questEntity.zzihc);
        zzbgo.zza((Parcel)parcel2, (int)14, (long)questEntity.getStartTimestamp());
        zzbgo.zzc((Parcel)parcel2, (int)15, (int)questEntity.getState());
        zzbgo.zzc((Parcel)parcel2, (int)16, (int)questEntity.zzenu);
        zzbgo.zzc((Parcel)parcel2, (int)17, questEntity.zzavw(), (boolean)false);
        zzbgo.zzai((Parcel)parcel2, (int)n2);
    }
}

