/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.api.AchievementsImpl;
import com.google.android.gms.games.internal.api.AclsImpl;
import com.google.android.gms.games.internal.api.AppContentsImpl;
import com.google.android.gms.games.internal.api.EventsImpl;
import com.google.android.gms.games.internal.api.GamesMetadataImpl;
import com.google.android.gms.games.internal.api.InvitationsImpl;
import com.google.android.gms.games.internal.api.LeaderboardsImpl;
import com.google.android.gms.games.internal.api.MultiplayerImpl;
import com.google.android.gms.games.internal.api.NotificationsImpl;
import com.google.android.gms.games.internal.api.PlayersImpl;
import com.google.android.gms.games.internal.api.QuestsImpl;
import com.google.android.gms.games.internal.api.RealTimeMultiplayerImpl;
import com.google.android.gms.games.internal.api.RequestsImpl;
import com.google.android.gms.games.internal.api.SnapshotsImpl;
import com.google.android.gms.games.internal.api.TurnBasedMultiplayerImpl;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshots;
import java.util.ArrayList;

public final class Games {
    public static final String EXTRA_PLAYER_IDS = "players";
    public static final String EXTRA_STATUS = "status";
    static final Api.zzc<GamesClientImpl> zzGR = new Api.zzc();
    private static final Api.zzb<GamesClientImpl, GamesOptions> zzGS = new Api.zzb<GamesClientImpl, GamesOptions>(){

        public GamesClientImpl zza(Context context, Looper looper, zzf zzf2, GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (gamesOptions == null) {
                gamesOptions = new GamesOptions();
            }
            return new GamesClientImpl(context, looper, zzf2, gamesOptions, connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return 1;
        }
    };
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final Api<GamesOptions> API = new Api(zzGS, zzGR, new Scope[]{SCOPE_GAMES});
    public static final Scope zzacv = new Scope("https://www.googleapis.com/auth/games.firstparty");
    public static final Api<GamesOptions> zzacw = new Api(zzGS, zzGR, new Scope[]{zzacv});
    public static final GamesMetadata GamesMetadata = new GamesMetadataImpl();
    public static final Achievements Achievements = new AchievementsImpl();
    public static final AppContents zzacx = new AppContentsImpl();
    public static final Events Events = new EventsImpl();
    public static final Leaderboards Leaderboards = new LeaderboardsImpl();
    public static final Invitations Invitations = new InvitationsImpl();
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new TurnBasedMultiplayerImpl();
    public static final RealTimeMultiplayer RealTimeMultiplayer = new RealTimeMultiplayerImpl();
    public static final Multiplayer zzacy = new MultiplayerImpl();
    public static final Players Players = new PlayersImpl();
    public static final Notifications Notifications = new NotificationsImpl();
    public static final Quests Quests = new QuestsImpl();
    public static final Requests Requests = new RequestsImpl();
    public static final Snapshots Snapshots = new SnapshotsImpl();
    public static final Acls zzacz = new AclsImpl();

    private Games() {
    }

    public static GamesClientImpl zzd(GoogleApiClient googleApiClient) {
        return Games.zzb(googleApiClient, true);
    }

    public static GamesClientImpl zzb(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzx.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return Games.zzc(googleApiClient, bl);
    }

    public static GamesClientImpl zzc(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.zzb(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Games.API and is not connected to Games. Use GoogleApiClient.hasConnectedApi(Games.API) to guard this call.");
        }
        return bl2 ? (GamesClientImpl)googleApiClient.zza(zzGR) : null;
    }

    public static void setGravityForPopups(GoogleApiClient apiClient, int gravity) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzeB(gravity);
        }
    }

    public static void setViewForPopups(GoogleApiClient apiClient, View gamesContentView) {
        zzx.zzl((Object)gamesContentView);
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzl(gamesContentView);
        }
    }

    public static String getCurrentAccountName(GoogleApiClient apiClient) {
        return Games.zzd(apiClient).zznp();
    }

    public static String getAppId(GoogleApiClient apiClient) {
        return Games.zzd(apiClient).zznE();
    }

    public static Intent getSettingsIntent(GoogleApiClient apiClient) {
        return Games.zzd(apiClient).zznC();
    }

    public static PendingResult<Status> signOut(GoogleApiClient apiClient) {
        return apiClient.zzb((zza.zza)new SignOutImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zza.zzb<Status>)this);
            }
        });
    }

    public static int getSdkVariant(GoogleApiClient apiClient) {
        return Games.zzd(apiClient).zznD();
    }

    private static abstract class SignOutImpl
    extends BaseGamesApiMethodImpl<Status> {
        private SignOutImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzb(x0);
        }
    }

    public static abstract class BaseGamesApiMethodImpl<R extends Result>
    extends zza.zza<R, GamesClientImpl> {
        public BaseGamesApiMethodImpl(GoogleApiClient googleApiClient) {
            super(zzGR, googleApiClient);
        }
    }

    public static final class GamesOptions
    implements Api.ApiOptions.Optional {
        public final boolean zzacA;
        public final boolean zzacB;
        public final int zzacC;
        public final boolean zzacD;
        public final int zzacE;
        public final String zzacF;
        public final ArrayList<String> zzacG;

        private GamesOptions() {
            this.zzacA = false;
            this.zzacB = true;
            this.zzacC = 17;
            this.zzacD = false;
            this.zzacE = 4368;
            this.zzacF = null;
            this.zzacG = new ArrayList();
        }

        private GamesOptions(Builder builder) {
            this.zzacA = builder.zzacA;
            this.zzacB = builder.zzacB;
            this.zzacC = builder.zzacC;
            this.zzacD = builder.zzacD;
            this.zzacE = builder.zzacE;
            this.zzacF = builder.zzacF;
            this.zzacG = builder.zzacG;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            boolean zzacA = false;
            boolean zzacB = true;
            int zzacC = 17;
            boolean zzacD = false;
            int zzacE = 4368;
            String zzacF = null;
            ArrayList<String> zzacG = new ArrayList();

            private Builder() {
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup) {
                this.zzacB = showConnectingPopup;
                this.zzacC = 17;
                return this;
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup, int gravity) {
                this.zzacB = showConnectingPopup;
                this.zzacC = gravity;
                return this;
            }

            public Builder setSdkVariant(int variant) {
                this.zzacE = variant;
                return this;
            }

            public GamesOptions build() {
                return new GamesOptions(this);
            }
        }
    }
}

