/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.PlayerLevelCreator;

public final class PlayerLevel
implements SafeParcelable {
    public static final PlayerLevelCreator CREATOR = new PlayerLevelCreator();
    private final int zzFG;
    private final int zzacP;
    private final long zzacQ;
    private final long zzacR;

    public PlayerLevel(int value, long minXp, long maxXp) {
        this(1, value, minXp, maxXp);
    }

    PlayerLevel(int versionCode, int levelNumber, long minXp, long maxXp) {
        zzx.zza((minXp >= 0L ? 1 : 0) != 0, (Object)"Min XP must be positive!");
        zzx.zza((maxXp > minXp ? 1 : 0) != 0, (Object)"Max XP must be more than min XP!");
        this.zzFG = versionCode;
        this.zzacP = levelNumber;
        this.zzacQ = minXp;
        this.zzacR = maxXp;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    public int getLevelNumber() {
        return this.zzacP;
    }

    public long getMinXp() {
        return this.zzacQ;
    }

    public long getMaxXp() {
        return this.zzacR;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzacP, this.zzacQ, this.zzacR});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevel)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PlayerLevel playerLevel = (PlayerLevel)obj;
        return zzw.equal((Object)playerLevel.getLevelNumber(), (Object)this.getLevelNumber()) && zzw.equal((Object)playerLevel.getMinXp(), (Object)this.getMinXp()) && zzw.equal((Object)playerLevel.getMaxXp(), (Object)this.getMaxXp());
    }

    public String toString() {
        return zzw.zzk((Object)this).zza("LevelNumber", (Object)this.getLevelNumber()).zza("MinXp", (Object)this.getMinXp()).zza("MaxXp", (Object)this.getMaxXp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelCreator.zza(this, out, flags);
    }
}

