/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzd;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends zzd
implements Player {
    private final PlayerColumnNames zzacW;
    private final PlayerLevelInfo zzacM;
    private final MostRecentGameInfoRef zzacX;

    public PlayerRef(DataHolder holder, int dataRow) {
        this(holder, dataRow, null);
    }

    public PlayerRef(DataHolder holder, int dataRow, String prefix) {
        super(holder, dataRow);
        this.zzacW = new PlayerColumnNames(prefix);
        this.zzacX = new MostRecentGameInfoRef(holder, dataRow, this.zzacW);
        if (this.zzmG()) {
            PlayerLevel playerLevel;
            int n = this.getInteger(this.zzacW.zzaiy);
            int n2 = this.getInteger(this.zzacW.zzaiB);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n, this.getLong(this.zzacW.zzaiz), this.getLong(this.zzacW.zzaiA));
            if (n != n2) {
                playerLevel2 = new PlayerLevel(n2, this.getLong(this.zzacW.zzaiA), this.getLong(this.zzacW.zzaiC));
            }
            this.zzacM = new PlayerLevelInfo(this.getLong(this.zzacW.zzaix), this.getLong(this.zzacW.zzaiD), playerLevel, playerLevel2);
        } else {
            this.zzacM = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.zzacW.zzaio);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.zzacW.zzaip);
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.zza(this.zzacW.zzaip, dataOut);
    }

    @Override
    public boolean zzmD() {
        return this.getBoolean(this.zzacW.zzaiN);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzbb(this.zzacW.zzaiq);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.zzacW.zzair);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzbb(this.zzacW.zzais);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.zzacW.zzait);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.zzacW.zzaiu);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.zzba(this.zzacW.zzaiw) || this.zzbc(this.zzacW.zzaiw)) {
            return -1L;
        }
        return this.getLong(this.zzacW.zzaiw);
    }

    @Override
    public int zzmE() {
        return this.getInteger(this.zzacW.zzaiv);
    }

    @Override
    public boolean isProfileVisible() {
        return this.getBoolean(this.zzacW.zzaiG);
    }

    @Override
    public String getTitle() {
        return this.getString(this.zzacW.zzaiE);
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        this.zza(this.zzacW.zzaiE, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzacM;
    }

    @Override
    public MostRecentGameInfo zzmF() {
        if (this.zzbc(this.zzacW.zzaiH)) {
            return null;
        }
        return this.zzacX;
    }

    public Player freeze() {
        return new PlayerEntity(this);
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    public boolean equals(Object obj) {
        return PlayerEntity.zza(this, obj);
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        PlayerEntity playerEntity = (PlayerEntity)this.freeze();
        playerEntity.writeToParcel(dest, flags);
    }

    private boolean zzmG() {
        if (this.zzbc(this.zzacW.zzaix)) {
            return false;
        }
        return this.getLong(this.zzacW.zzaix) != -1L;
    }
}

