/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.os.Parcel;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.ExtendedGame;
import com.google.android.gms.games.internal.game.ExtendedGameEntityCreator;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;
import java.util.ArrayList;

public final class ExtendedGameEntity
extends GamesDowngradeableSafeParcel
implements ExtendedGame {
    public static final ExtendedGameEntityCreator CREATOR = new ExtendedGameEntityCreatorCompat();
    private final int zzFG;
    private final GameEntity zzahV;
    private final int zzahW;
    private final boolean zzahX;
    private final int zzahY;
    private final long zzahZ;
    private final long zzaia;
    private final String zzaib;
    private final long zzaic;
    private final String zzaid;
    private final ArrayList<GameBadgeEntity> zzaie;
    private final SnapshotMetadataEntity zzaif;

    public ExtendedGameEntity(ExtendedGame extendedGame) {
        this.zzFG = 2;
        Game game = extendedGame.getGame();
        this.zzahV = game == null ? null : new GameEntity(game);
        this.zzahW = extendedGame.zzoi();
        this.zzahX = extendedGame.zzoj();
        this.zzahY = extendedGame.zzok();
        this.zzahZ = extendedGame.zzol();
        this.zzaia = extendedGame.zzom();
        this.zzaib = extendedGame.zzon();
        this.zzaic = extendedGame.zzoo();
        this.zzaid = extendedGame.zzop();
        SnapshotMetadata snapshotMetadata = extendedGame.zzoq();
        this.zzaif = snapshotMetadata == null ? null : new SnapshotMetadataEntity(snapshotMetadata);
        ArrayList<GameBadge> arrayList = extendedGame.zzoh();
        int n = arrayList.size();
        this.zzaie = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaie.add((GameBadgeEntity)arrayList.get(i).freeze());
        }
    }

    ExtendedGameEntity(int versionCode, GameEntity game, int availability, boolean owned, int achievementUnlockedCount, long lastPlayedServerTimestamp, long priceMicros, String formattedPrice, long fullPriceMicros, String formattedFullPrice, ArrayList<GameBadgeEntity> badges, SnapshotMetadataEntity snapshot) {
        this.zzFG = versionCode;
        this.zzahV = game;
        this.zzahW = availability;
        this.zzahX = owned;
        this.zzahY = achievementUnlockedCount;
        this.zzahZ = lastPlayedServerTimestamp;
        this.zzaia = priceMicros;
        this.zzaib = formattedPrice;
        this.zzaic = fullPriceMicros;
        this.zzaid = formattedFullPrice;
        this.zzaie = badges;
        this.zzaif = snapshot;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    public GameEntity zzor() {
        return this.zzahV;
    }

    @Override
    public ArrayList<GameBadge> zzoh() {
        return new ArrayList<GameBadge>(this.zzaie);
    }

    @Override
    public int zzoi() {
        return this.zzahW;
    }

    @Override
    public boolean zzoj() {
        return this.zzahX;
    }

    @Override
    public int zzok() {
        return this.zzahY;
    }

    @Override
    public long zzol() {
        return this.zzahZ;
    }

    @Override
    public long zzom() {
        return this.zzaia;
    }

    @Override
    public String zzon() {
        return this.zzaib;
    }

    @Override
    public long zzoo() {
        return this.zzaic;
    }

    @Override
    public String zzop() {
        return this.zzaid;
    }

    @Override
    public SnapshotMetadata zzoq() {
        return this.zzaif;
    }

    public ExtendedGame zzos() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ExtendedGameEntity.zza(this);
    }

    static int zza(ExtendedGame extendedGame) {
        return zzw.hashCode((Object[])new Object[]{extendedGame.getGame(), extendedGame.zzoi(), extendedGame.zzoj(), extendedGame.zzok(), extendedGame.zzol(), extendedGame.zzom(), extendedGame.zzon(), extendedGame.zzoo(), extendedGame.zzop()});
    }

    public boolean equals(Object obj) {
        return ExtendedGameEntity.zza(this, obj);
    }

    static boolean zza(ExtendedGame extendedGame, Object object) {
        if (!(object instanceof ExtendedGame)) {
            return false;
        }
        if (extendedGame == object) {
            return true;
        }
        ExtendedGame extendedGame2 = (ExtendedGame)object;
        return zzw.equal((Object)extendedGame2.getGame(), (Object)extendedGame.getGame()) && zzw.equal((Object)extendedGame2.zzoi(), (Object)extendedGame.zzoi()) && zzw.equal((Object)extendedGame2.zzoj(), (Object)extendedGame.zzoj()) && zzw.equal((Object)extendedGame2.zzok(), (Object)extendedGame.zzok()) && zzw.equal((Object)extendedGame2.zzol(), (Object)extendedGame.zzol()) && zzw.equal((Object)extendedGame2.zzom(), (Object)extendedGame.zzom()) && zzw.equal((Object)extendedGame2.zzon(), (Object)extendedGame.zzon()) && zzw.equal((Object)extendedGame2.zzoo(), (Object)extendedGame.zzoo()) && zzw.equal((Object)extendedGame2.zzop(), (Object)extendedGame.zzop());
    }

    public String toString() {
        return ExtendedGameEntity.zzb(this);
    }

    static String zzb(ExtendedGame extendedGame) {
        return zzw.zzk((Object)extendedGame).zza("Game", (Object)extendedGame.getGame()).zza("Availability", (Object)extendedGame.zzoi()).zza("Owned", (Object)extendedGame.zzoj()).zza("AchievementUnlockedCount", (Object)extendedGame.zzok()).zza("LastPlayedServerTimestamp", (Object)extendedGame.zzol()).zza("PriceMicros", (Object)extendedGame.zzom()).zza("FormattedPrice", (Object)extendedGame.zzon()).zza("FullPriceMicros", (Object)extendedGame.zzoo()).zza("FormattedFullPrice", (Object)extendedGame.zzop()).zza("Snapshot", (Object)extendedGame.zzoq()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zziY()) {
            ExtendedGameEntityCreator.zza(this, dest, flags);
        } else {
            this.zzahV.writeToParcel(dest, flags);
            dest.writeInt(this.zzahW);
            dest.writeInt(this.zzahX ? 1 : 0);
            dest.writeInt(this.zzahY);
            dest.writeLong(this.zzahZ);
            dest.writeLong(this.zzaia);
            dest.writeString(this.zzaib);
            dest.writeLong(this.zzaic);
            dest.writeString(this.zzaid);
            int n = this.zzaie.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.zzaie.get(i).writeToParcel(dest, flags);
            }
        }
    }

    @Override
    public /* synthetic */ Game getGame() {
        return this.zzor();
    }

    public /* synthetic */ Object freeze() {
        return this.zzos();
    }

    static final class ExtendedGameEntityCreatorCompat
    extends ExtendedGameEntityCreator {
        ExtendedGameEntityCreatorCompat() {
        }

        @Override
        public ExtendedGameEntity zzcZ(Parcel parcel) {
            boolean bl = ExtendedGameEntity.zzd(ExtendedGameEntity.zziX());
            if (bl || ExtendedGameEntity.zzbf((String)ExtendedGameEntity.class.getCanonicalName())) {
                return super.zzcZ(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            int n = parcel.readInt();
            boolean bl2 = parcel.readInt() == 1;
            int n2 = parcel.readInt();
            long l = parcel.readLong();
            long l2 = parcel.readLong();
            String string = parcel.readString();
            long l3 = parcel.readLong();
            String string2 = parcel.readString();
            int n3 = parcel.readInt();
            ArrayList<GameBadgeEntity> arrayList = new ArrayList<GameBadgeEntity>(n3);
            for (int i = 0; i < n3; ++i) {
                arrayList.add(GameBadgeEntity.CREATOR.zzda(parcel));
            }
            SnapshotMetadataEntity snapshotMetadataEntity = null;
            return new ExtendedGameEntity(2, gameEntity, n, bl2, n2, l, l2, string, l3, string2, arrayList, snapshotMetadataEntity);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzcZ(x0);
        }
    }
}

