/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.zzlw;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final TurnBasedMatchEntityCreator CREATOR = new TurnBasedMatchEntityCreator();
    private final int zzFG;
    private final GameEntity zzahV;
    private final String zzaeF;
    private final String zzajS;
    private final long zzajw;
    private final String zzaka;
    private final long zzadi;
    private final String zzakb;
    private final int zzakc;
    private final int zzajA;
    private final int zzHe;
    private final byte[] zzakd;
    private final ArrayList<ParticipantEntity> zzajz;
    private final String zzake;
    private final byte[] zzakf;
    private final int zzakg;
    private final Bundle zzajQ;
    private final int zzakh;
    private final boolean zzaki;
    private final String zzZO;
    private final String zzakj;

    public TurnBasedMatchEntity(TurnBasedMatch match) {
        this.zzFG = 2;
        this.zzahV = new GameEntity(match.getGame());
        this.zzaeF = match.getMatchId();
        this.zzajS = match.getCreatorId();
        this.zzajw = match.getCreationTimestamp();
        this.zzaka = match.getLastUpdaterId();
        this.zzadi = match.getLastUpdatedTimestamp();
        this.zzakb = match.getPendingParticipantId();
        this.zzakc = match.getStatus();
        this.zzakh = match.getTurnStatus();
        this.zzajA = match.getVariant();
        this.zzHe = match.getVersion();
        this.zzake = match.getRematchId();
        this.zzakg = match.getMatchNumber();
        this.zzajQ = match.getAutoMatchCriteria();
        this.zzaki = match.isLocallyModified();
        this.zzZO = match.getDescription();
        this.zzakj = match.getDescriptionParticipantId();
        byte[] byArray = match.getData();
        if (byArray == null) {
            this.zzakd = null;
        } else {
            this.zzakd = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzakd, 0, byArray.length);
        }
        byte[] byArray2 = match.getPreviousMatchData();
        if (byArray2 == null) {
            this.zzakf = null;
        } else {
            this.zzakf = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.zzakf, 0, byArray2.length);
        }
        ArrayList arrayList = match.getParticipants();
        int n = arrayList.size();
        this.zzajz = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzajz.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(int versionCode, GameEntity game, String matchId, String creatorId, long creationTimestamp, String lastUpdaterId, long lastUpdatedTimestamp, String pendingParticipantId, int matchStatus, int variant, int version, byte[] data, ArrayList<ParticipantEntity> participants, String rematchId, byte[] previousData, int matchNumber, Bundle autoMatchCriteria, int turnStatus, boolean isLocallyModified, String description, String descriptionParticipantId) {
        this.zzFG = versionCode;
        this.zzahV = game;
        this.zzaeF = matchId;
        this.zzajS = creatorId;
        this.zzajw = creationTimestamp;
        this.zzaka = lastUpdaterId;
        this.zzadi = lastUpdatedTimestamp;
        this.zzakb = pendingParticipantId;
        this.zzakc = matchStatus;
        this.zzakh = turnStatus;
        this.zzajA = variant;
        this.zzHe = version;
        this.zzakd = data;
        this.zzajz = participants;
        this.zzake = rematchId;
        this.zzakf = previousData;
        this.zzakg = matchNumber;
        this.zzajQ = autoMatchCriteria;
        this.zzaki = isLocallyModified;
        this.zzZO = description;
        this.zzakj = descriptionParticipantId;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public Game getGame() {
        return this.zzahV;
    }

    @Override
    public String getMatchId() {
        return this.zzaeF;
    }

    @Override
    public String getCreatorId() {
        return this.zzajS;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzajw;
    }

    @Override
    public String getLastUpdaterId() {
        return this.zzaka;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzadi;
    }

    @Override
    public String getPendingParticipantId() {
        return this.zzakb;
    }

    @Override
    public int getStatus() {
        return this.zzakc;
    }

    @Override
    public int getTurnStatus() {
        return this.zzakh;
    }

    @Override
    public String getDescription() {
        return this.zzZO;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.zzakj;
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzZO, (CharArrayBuffer)dataOut);
    }

    @Override
    public int getVariant() {
        return this.zzajA;
    }

    @Override
    public byte[] getData() {
        return this.zzakd;
    }

    @Override
    public int getVersion() {
        return this.zzHe;
    }

    @Override
    public String getRematchId() {
        return this.zzake;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.zzakf;
    }

    @Override
    public int getMatchNumber() {
        return this.zzakg;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzajQ;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.zzajQ == null) {
            return 0;
        }
        return this.zzajQ.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.zzakc == 2 && this.zzake == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.zzaki;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.zzb(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.zzc(this, participantId);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzajz);
    }

    public TurnBasedMatch freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return zzw.hashCode((Object[])new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, obj);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzw.equal((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && zzw.equal((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && zzw.equal((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && zzw.equal((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && zzw.equal((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && zzw.equal((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && zzw.equal((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && zzw.equal((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && zzw.equal((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && zzw.equal((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && zzw.equal((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && zzw.equal((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && zzw.equal((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && zzw.equal((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && zzw.equal((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && zzw.equal((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && zzw.equal((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && zzw.equal((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzw.zzk((Object)turnBasedMatch).zza("Game", (Object)turnBasedMatch.getGame()).zza("MatchId", (Object)turnBasedMatch.getMatchId()).zza("CreatorId", (Object)turnBasedMatch.getCreatorId()).zza("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).zza("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).zza("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).zza("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).zza("MatchStatus", (Object)turnBasedMatch.getStatus()).zza("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).zza("Description", (Object)turnBasedMatch.getDescription()).zza("Variant", (Object)turnBasedMatch.getVariant()).zza("Data", (Object)turnBasedMatch.getData()).zza("Version", (Object)turnBasedMatch.getVersion()).zza("Participants", (Object)turnBasedMatch.getParticipants()).zza("RematchId", (Object)turnBasedMatch.getRematchId()).zza("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).zza("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).zza("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).zza("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).zza("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).zza("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        TurnBasedMatchEntityCreator.zza(this, out, flags);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + turnBasedMatch.getMatchId());
    }
}

