/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntityCreator;
import com.google.android.gms.internal.zzlw;

public final class SnapshotMetadataEntity
implements SafeParcelable,
SnapshotMetadata {
    public static final SnapshotMetadataEntityCreator CREATOR = new SnapshotMetadataEntityCreator();
    private final int zzFG;
    private final GameEntity zzahV;
    private final PlayerEntity zzakK;
    private final String zzaef;
    private final Uri zzakH;
    private final String zzakL;
    private final String zzSy;
    private final String zzZO;
    private final long zzakM;
    private final long zzakN;
    private final float zzakO;
    private final String zzakP;
    private final boolean zzakQ;
    private final long zzakR;

    public SnapshotMetadataEntity(SnapshotMetadata snapshotMetadata) {
        this.zzFG = 5;
        this.zzahV = new GameEntity(snapshotMetadata.getGame());
        this.zzakK = new PlayerEntity(snapshotMetadata.getOwner());
        this.zzaef = snapshotMetadata.getSnapshotId();
        this.zzakH = snapshotMetadata.getCoverImageUri();
        this.zzakL = snapshotMetadata.getCoverImageUrl();
        this.zzakO = snapshotMetadata.getCoverImageAspectRatio();
        this.zzSy = snapshotMetadata.getTitle();
        this.zzZO = snapshotMetadata.getDescription();
        this.zzakM = snapshotMetadata.getLastModifiedTimestamp();
        this.zzakN = snapshotMetadata.getPlayedTime();
        this.zzakP = snapshotMetadata.getUniqueName();
        this.zzakQ = snapshotMetadata.hasChangePending();
        this.zzakR = snapshotMetadata.getProgressValue();
    }

    SnapshotMetadataEntity(int versionCode, GameEntity game, PlayerEntity owner, String snapshotId, Uri coverImageUri, String coverImageUrl, String title, String description, long lastModifiedTimestamp, long playedTime, float coverImageAspectRatio, String uniqueName, boolean changePending, long progressValue) {
        this.zzFG = versionCode;
        this.zzahV = game;
        this.zzakK = owner;
        this.zzaef = snapshotId;
        this.zzakH = coverImageUri;
        this.zzakL = coverImageUrl;
        this.zzakO = coverImageAspectRatio;
        this.zzSy = title;
        this.zzZO = description;
        this.zzakM = lastModifiedTimestamp;
        this.zzakN = playedTime;
        this.zzakP = uniqueName;
        this.zzakQ = changePending;
        this.zzakR = progressValue;
    }

    public int getVersionCode() {
        return this.zzFG;
    }

    @Override
    public Game getGame() {
        return this.zzahV;
    }

    @Override
    public Player getOwner() {
        return this.zzakK;
    }

    @Override
    public String getSnapshotId() {
        return this.zzaef;
    }

    @Override
    public Uri getCoverImageUri() {
        return this.zzakH;
    }

    @Override
    public String getCoverImageUrl() {
        return this.zzakL;
    }

    @Override
    public float getCoverImageAspectRatio() {
        return this.zzakO;
    }

    @Override
    public String getUniqueName() {
        return this.zzakP;
    }

    @Override
    public String getTitle() {
        return this.zzSy;
    }

    @Override
    public String getDescription() {
        return this.zzZO;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlw.zzb((String)this.zzZO, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.zzakM;
    }

    @Override
    public long getPlayedTime() {
        return this.zzakN;
    }

    @Override
    public boolean hasChangePending() {
        return this.zzakQ;
    }

    @Override
    public long getProgressValue() {
        return this.zzakR;
    }

    public SnapshotMetadata freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.zza(this);
    }

    static int zza(SnapshotMetadata snapshotMetadata) {
        return zzw.hashCode((Object[])new Object[]{snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.getTitle(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName(), snapshotMetadata.hasChangePending(), snapshotMetadata.getProgressValue()});
    }

    public boolean equals(Object obj) {
        return SnapshotMetadataEntity.zza(this, obj);
    }

    static boolean zza(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        SnapshotMetadata snapshotMetadata2 = (SnapshotMetadata)object;
        return zzw.equal((Object)snapshotMetadata2.getGame(), (Object)snapshotMetadata.getGame()) && zzw.equal((Object)snapshotMetadata2.getOwner(), (Object)snapshotMetadata.getOwner()) && zzw.equal((Object)snapshotMetadata2.getSnapshotId(), (Object)snapshotMetadata.getSnapshotId()) && zzw.equal((Object)snapshotMetadata2.getCoverImageUri(), (Object)snapshotMetadata.getCoverImageUri()) && zzw.equal((Object)Float.valueOf(snapshotMetadata2.getCoverImageAspectRatio()), (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && zzw.equal((Object)snapshotMetadata2.getTitle(), (Object)snapshotMetadata.getTitle()) && zzw.equal((Object)snapshotMetadata2.getDescription(), (Object)snapshotMetadata.getDescription()) && zzw.equal((Object)snapshotMetadata2.getLastModifiedTimestamp(), (Object)snapshotMetadata.getLastModifiedTimestamp()) && zzw.equal((Object)snapshotMetadata2.getPlayedTime(), (Object)snapshotMetadata.getPlayedTime()) && zzw.equal((Object)snapshotMetadata2.getUniqueName(), (Object)snapshotMetadata.getUniqueName()) && zzw.equal((Object)snapshotMetadata2.hasChangePending(), (Object)snapshotMetadata.hasChangePending()) && zzw.equal((Object)snapshotMetadata2.getProgressValue(), (Object)snapshotMetadata.getProgressValue());
    }

    public String toString() {
        return SnapshotMetadataEntity.zzb(this);
    }

    static String zzb(SnapshotMetadata snapshotMetadata) {
        return zzw.zzk((Object)snapshotMetadata).zza("Game", (Object)snapshotMetadata.getGame()).zza("Owner", (Object)snapshotMetadata.getOwner()).zza("SnapshotId", (Object)snapshotMetadata.getSnapshotId()).zza("CoverImageUri", (Object)snapshotMetadata.getCoverImageUri()).zza("CoverImageUrl", (Object)snapshotMetadata.getCoverImageUrl()).zza("CoverImageAspectRatio", (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).zza("Description", (Object)snapshotMetadata.getDescription()).zza("LastModifiedTimestamp", (Object)snapshotMetadata.getLastModifiedTimestamp()).zza("PlayedTime", (Object)snapshotMetadata.getPlayedTime()).zza("UniqueName", (Object)snapshotMetadata.getUniqueName()).zza("ChangePending", (Object)snapshotMetadata.hasChangePending()).zza("ProgressValue", (Object)snapshotMetadata.getProgressValue()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataEntityCreator.zza(this, out, flags);
    }
}

