/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.zzhu;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int zzzH;
    private final String zzLD;
    private final String zzWF;
    private final String zzafV;
    private final String zzafW;
    private final String zzadH;
    private final String zzafX;
    private final Uri zzafY;
    private final Uri zzafZ;
    private final Uri zzaga;
    private final boolean zzagb;
    private final boolean zzagc;
    private final String zzagd;
    private final int zzage;
    private final int zzagf;
    private final int zzagg;
    private final boolean zzagh;
    private final boolean zzagi;
    private final String zzagj;
    private final String zzagk;
    private final String zzagl;
    private final boolean zzwP;
    private final boolean zzagm;
    private final boolean zzagn;
    private final String zzago;
    private final boolean zzagp;

    public GameEntity(Game game) {
        this.zzzH = 6;
        this.zzLD = game.getApplicationId();
        this.zzafV = game.getPrimaryCategory();
        this.zzafW = game.getSecondaryCategory();
        this.zzadH = game.getDescription();
        this.zzafX = game.getDeveloperName();
        this.zzWF = game.getDisplayName();
        this.zzafY = game.getIconImageUri();
        this.zzagj = game.getIconImageUrl();
        this.zzafZ = game.getHiResImageUri();
        this.zzagk = game.getHiResImageUrl();
        this.zzaga = game.getFeaturedImageUri();
        this.zzagl = game.getFeaturedImageUrl();
        this.zzagb = game.zzpM();
        this.zzagc = game.zzpO();
        this.zzagd = game.zzpP();
        this.zzage = game.zzpQ();
        this.zzagf = game.getAchievementTotalCount();
        this.zzagg = game.getLeaderboardCount();
        this.zzagh = game.isRealTimeMultiplayerEnabled();
        this.zzagi = game.isTurnBasedMultiplayerEnabled();
        this.zzwP = game.isMuted();
        this.zzagm = game.zzpN();
        this.zzagn = game.areSnapshotsEnabled();
        this.zzago = game.getThemeColor();
        this.zzagp = game.hasGamepadSupport();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed, boolean snapshotsEnabled, String themeColor, boolean hasGamepadSupport) {
        this.zzzH = versionCode;
        this.zzLD = applicationId;
        this.zzWF = displayName;
        this.zzafV = primaryCategory;
        this.zzafW = secondaryCategory;
        this.zzadH = description;
        this.zzafX = developerName;
        this.zzafY = iconImageUri;
        this.zzagj = iconImageUrl;
        this.zzafZ = hiResImageUri;
        this.zzagk = hiResImageUrl;
        this.zzaga = featuredImageUri;
        this.zzagl = featuredImageUrl;
        this.zzagb = playEnabledGame;
        this.zzagc = instanceInstalled;
        this.zzagd = instancePackageName;
        this.zzage = gameplayAclStatus;
        this.zzagf = achievementTotalCount;
        this.zzagg = leaderboardCount;
        this.zzagh = realTimeEnabled;
        this.zzagi = turnBasedEnabled;
        this.zzwP = muted;
        this.zzagm = identitySharingConfirmed;
        this.zzagn = snapshotsEnabled;
        this.zzago = themeColor;
        this.zzagp = hasGamepadSupport;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public String getApplicationId() {
        return this.zzLD;
    }

    @Override
    public String getDisplayName() {
        return this.zzWF;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzWF, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.zzafV;
    }

    @Override
    public String getSecondaryCategory() {
        return this.zzafW;
    }

    @Override
    public String getDescription() {
        return this.zzadH;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzadH, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.zzafX;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzafX, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzafY;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzagj;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzafZ;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzagk;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.zzaga;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.zzagl;
    }

    @Override
    public boolean isMuted() {
        return this.zzwP;
    }

    @Override
    public boolean zzpN() {
        return this.zzagm;
    }

    @Override
    public boolean zzpM() {
        return this.zzagb;
    }

    @Override
    public boolean zzpO() {
        return this.zzagc;
    }

    @Override
    public String zzpP() {
        return this.zzagd;
    }

    @Override
    public int zzpQ() {
        return this.zzage;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.zzagf;
    }

    @Override
    public int getLeaderboardCount() {
        return this.zzagg;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.zzagh;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.zzagi;
    }

    @Override
    public boolean areSnapshotsEnabled() {
        return this.zzagn;
    }

    @Override
    public String getThemeColor() {
        return this.zzago;
    }

    @Override
    public boolean hasGamepadSupport() {
        return this.zzagp;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.zza(this);
    }

    static int zza(Game game) {
        return zzu.hashCode((Object[])new Object[]{game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.zzpM(), game.zzpO(), game.zzpP(), game.zzpQ(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.zzpN(), game.areSnapshotsEnabled(), game.getThemeColor(), game.hasGamepadSupport()});
    }

    public boolean equals(Object obj) {
        return GameEntity.zza(this, obj);
    }

    static boolean zza(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return zzu.equal((Object)game2.getApplicationId(), (Object)game.getApplicationId()) && zzu.equal((Object)game2.getDisplayName(), (Object)game.getDisplayName()) && zzu.equal((Object)game2.getPrimaryCategory(), (Object)game.getPrimaryCategory()) && zzu.equal((Object)game2.getSecondaryCategory(), (Object)game.getSecondaryCategory()) && zzu.equal((Object)game2.getDescription(), (Object)game.getDescription()) && zzu.equal((Object)game2.getDeveloperName(), (Object)game.getDeveloperName()) && zzu.equal((Object)game2.getIconImageUri(), (Object)game.getIconImageUri()) && zzu.equal((Object)game2.getHiResImageUri(), (Object)game.getHiResImageUri()) && zzu.equal((Object)game2.getFeaturedImageUri(), (Object)game.getFeaturedImageUri()) && zzu.equal((Object)game2.zzpM(), (Object)game.zzpM()) && zzu.equal((Object)game2.zzpO(), (Object)game.zzpO()) && zzu.equal((Object)game2.zzpP(), (Object)game.zzpP()) && zzu.equal((Object)game2.zzpQ(), (Object)game.zzpQ()) && zzu.equal((Object)game2.getAchievementTotalCount(), (Object)game.getAchievementTotalCount()) && zzu.equal((Object)game2.getLeaderboardCount(), (Object)game.getLeaderboardCount()) && zzu.equal((Object)game2.isRealTimeMultiplayerEnabled(), (Object)game.isRealTimeMultiplayerEnabled()) && zzu.equal((Object)game2.isTurnBasedMultiplayerEnabled(), (Object)(game.isTurnBasedMultiplayerEnabled() && zzu.equal((Object)game2.isMuted(), (Object)game.isMuted()) && zzu.equal((Object)game2.zzpN(), (Object)game.zzpN()) ? 1 : 0)) && zzu.equal((Object)game2.areSnapshotsEnabled(), (Object)game.areSnapshotsEnabled()) && zzu.equal((Object)game2.getThemeColor(), (Object)game.getThemeColor()) && zzu.equal((Object)game2.hasGamepadSupport(), (Object)game.hasGamepadSupport());
    }

    public String toString() {
        return GameEntity.zzb(this);
    }

    static String zzb(Game game) {
        return zzu.zzq((Object)game).zzg("ApplicationId", (Object)game.getApplicationId()).zzg("DisplayName", (Object)game.getDisplayName()).zzg("PrimaryCategory", (Object)game.getPrimaryCategory()).zzg("SecondaryCategory", (Object)game.getSecondaryCategory()).zzg("Description", (Object)game.getDescription()).zzg("DeveloperName", (Object)game.getDeveloperName()).zzg("IconImageUri", (Object)game.getIconImageUri()).zzg("IconImageUrl", (Object)game.getIconImageUrl()).zzg("HiResImageUri", (Object)game.getHiResImageUri()).zzg("HiResImageUrl", (Object)game.getHiResImageUrl()).zzg("FeaturedImageUri", (Object)game.getFeaturedImageUri()).zzg("FeaturedImageUrl", (Object)game.getFeaturedImageUrl()).zzg("PlayEnabledGame", (Object)game.zzpM()).zzg("InstanceInstalled", (Object)game.zzpO()).zzg("InstancePackageName", (Object)game.zzpP()).zzg("AchievementTotalCount", (Object)game.getAchievementTotalCount()).zzg("LeaderboardCount", (Object)game.getLeaderboardCount()).zzg("RealTimeMultiplayerEnabled", (Object)game.isRealTimeMultiplayerEnabled()).zzg("TurnBasedMultiplayerEnabled", (Object)game.isTurnBasedMultiplayerEnabled()).zzg("AreSnapshotsEnabled", (Object)game.areSnapshotsEnabled()).zzg("ThemeColor", (Object)game.getThemeColor()).zzg("HasGamepadSupport", (Object)game.hasGamepadSupport()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzlQ()) {
            GameEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzLD);
            dest.writeString(this.zzWF);
            dest.writeString(this.zzafV);
            dest.writeString(this.zzafW);
            dest.writeString(this.zzadH);
            dest.writeString(this.zzafX);
            dest.writeString(this.zzafY == null ? null : this.zzafY.toString());
            dest.writeString(this.zzafZ == null ? null : this.zzafZ.toString());
            dest.writeString(this.zzaga == null ? null : this.zzaga.toString());
            dest.writeInt(this.zzagb ? 1 : 0);
            dest.writeInt(this.zzagc ? 1 : 0);
            dest.writeString(this.zzagd);
            dest.writeInt(this.zzage);
            dest.writeInt(this.zzagf);
            dest.writeInt(this.zzagg);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity zzdd(Parcel parcel) {
            boolean bl = GameEntity.zzd(GameEntity.zzlP());
            if (bl || GameEntity.zzbK((String)GameEntity.class.getCanonicalName())) {
                return super.zzdd(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            boolean bl4 = false;
            boolean bl5 = false;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            String string14 = null;
            boolean bl9 = false;
            return new GameEntity(6, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl2, bl3, string10, n, n2, n3, bl4, bl5, string11, string12, string13, bl6, bl7, bl8, string14, bl9);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdd(x0);
        }
    }
}

