/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;
import com.google.android.gms.internal.zzhu;

public final class AchievementEntity
implements SafeParcelable,
Achievement {
    public static final AchievementEntityCreator CREATOR = new AchievementEntityCreator();
    private final int zzzH;
    private final String zzagT;
    private final int zzMG;
    private final String mName;
    private final String zzadH;
    private final Uri zzagU;
    private final String zzagV;
    private final Uri zzagW;
    private final String zzagX;
    private final int zzagY;
    private final String zzagZ;
    private final PlayerEntity zzaha;
    private final int mState;
    private final int zzahb;
    private final String zzahc;
    private final long zzahd;
    private final long zzahe;

    public AchievementEntity(Achievement achievement) {
        this.zzzH = 1;
        this.zzagT = achievement.getAchievementId();
        this.zzMG = achievement.getType();
        this.mName = achievement.getName();
        this.zzadH = achievement.getDescription();
        this.zzagU = achievement.getUnlockedImageUri();
        this.zzagV = achievement.getUnlockedImageUrl();
        this.zzagW = achievement.getRevealedImageUri();
        this.zzagX = achievement.getRevealedImageUrl();
        this.zzaha = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzahd = achievement.getLastUpdatedTimestamp();
        this.zzahe = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzagY = achievement.getTotalSteps();
            this.zzagZ = achievement.getFormattedTotalSteps();
            this.zzahb = achievement.getCurrentSteps();
            this.zzahc = achievement.getFormattedCurrentSteps();
        } else {
            this.zzagY = 0;
            this.zzagZ = null;
            this.zzahb = 0;
            this.zzahc = null;
        }
        zzb.zzn((Object)this.zzagT);
        zzb.zzn((Object)this.zzadH);
    }

    AchievementEntity(int versionCode, String achievementId, int type, String name, String description, Uri unlockedImageUri, String unlockedImageUrl, Uri revealedImageUri, String revealedImageUrl, int totalSteps, String formattedTotalSteps, PlayerEntity player, int state, int currentSteps, String formattedCurrentSteps, long lastUpdatedTimestamp, long xpValue) {
        this.zzzH = versionCode;
        this.zzagT = achievementId;
        this.zzMG = type;
        this.mName = name;
        this.zzadH = description;
        this.zzagU = unlockedImageUri;
        this.zzagV = unlockedImageUrl;
        this.zzagW = revealedImageUri;
        this.zzagX = revealedImageUrl;
        this.zzagY = totalSteps;
        this.zzagZ = formattedTotalSteps;
        this.zzaha = player;
        this.mState = state;
        this.zzahb = currentSteps;
        this.zzahc = formattedCurrentSteps;
        this.zzahd = lastUpdatedTimestamp;
        this.zzahe = xpValue;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public String getAchievementId() {
        return this.zzagT;
    }

    @Override
    public int getType() {
        return this.zzMG;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzadH;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzadH, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.zzagU;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.zzagV;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.zzagW;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.zzagX;
    }

    @Override
    public int getTotalSteps() {
        return this.zzagY;
    }

    @Override
    public String getFormattedTotalSteps() {
        return this.zzagZ;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzagZ, (CharArrayBuffer)dataOut);
    }

    @Override
    public Player getPlayer() {
        return this.zzaha;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        return this.zzahb;
    }

    @Override
    public String getFormattedCurrentSteps() {
        return this.zzahc;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzahc, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzahd;
    }

    @Override
    public long getXpValue() {
        return this.zzahe;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.zza(this);
    }

    static int zza(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return zzu.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object obj) {
        return AchievementEntity.zza(this, obj);
    }

    static boolean zza(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = zzu.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = zzu.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return zzu.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && zzu.equal((Object)achievement2.getName(), (Object)achievement.getName()) && zzu.equal((Object)achievement2.getType(), (Object)achievement.getType()) && zzu.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && zzu.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && zzu.equal((Object)achievement2.getState(), (Object)achievement.getState()) && zzu.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && zzu.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    static String zzb(Achievement achievement) {
        zzu.zza zza2 = zzu.zzq((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zza2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zza2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zza2.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AchievementEntityCreator.zza(this, dest, flags);
    }
}

