/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.internal.zzhu;

public final class EventEntity
implements SafeParcelable,
Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int zzzH;
    private final String zzahE;
    private final String mName;
    private final String zzadH;
    private final Uri zzafY;
    private final String zzagj;
    private final PlayerEntity zzaha;
    private final long zzahF;
    private final String zzahG;
    private final boolean zzahH;

    public EventEntity(Event event) {
        this.zzzH = 1;
        this.zzahE = event.getEventId();
        this.mName = event.getName();
        this.zzadH = event.getDescription();
        this.zzafY = event.getIconImageUri();
        this.zzagj = event.getIconImageUrl();
        this.zzaha = (PlayerEntity)event.getPlayer().freeze();
        this.zzahF = event.getValue();
        this.zzahG = event.getFormattedValue();
        this.zzahH = event.isVisible();
    }

    EventEntity(int versionCode, String eventId, String name, String description, Uri iconImageUri, String iconImageUrl, Player player, long value, String formattedValue, boolean isVisible) {
        this.zzzH = versionCode;
        this.zzahE = eventId;
        this.mName = name;
        this.zzadH = description;
        this.zzafY = iconImageUri;
        this.zzagj = iconImageUrl;
        this.zzaha = new PlayerEntity(player);
        this.zzahF = value;
        this.zzahG = formattedValue;
        this.zzahH = isVisible;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public String getEventId() {
        return this.zzahE;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzadH;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzadH, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzafY;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzagj;
    }

    @Override
    public Player getPlayer() {
        return this.zzaha;
    }

    @Override
    public long getValue() {
        return this.zzahF;
    }

    @Override
    public String getFormattedValue() {
        return this.zzahG;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzahG, (CharArrayBuffer)dataOut);
    }

    @Override
    public boolean isVisible() {
        return this.zzahH;
    }

    public Event freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzu.hashCode((Object[])new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public boolean equals(Object obj) {
        return EventEntity.zza(this, obj);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzu.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzu.equal((Object)event2.getName(), (Object)event.getName()) && zzu.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzu.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzu.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzu.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzu.equal((Object)event2.getValue(), (Object)event.getValue()) && zzu.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzu.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzu.zzq((Object)event).zzg("Id", (Object)event.getEventId()).zzg("Name", (Object)event.getName()).zzg("Description", (Object)event.getDescription()).zzg("IconImageUri", (Object)event.getIconImageUri()).zzg("IconImageUrl", (Object)event.getIconImageUrl()).zzg("Player", (Object)event.getPlayer()).zzg("Value", (Object)event.getValue()).zzg("FormattedValue", (Object)event.getFormattedValue()).zzg("isVisible", (Object)event.isVisible()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        EventEntityCreator.zza(this, out, flags);
    }
}

