/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.internal.zzic;
import java.lang.ref.WeakReference;

public class PopupManager {
    protected GamesClientImpl zzajo;
    protected PopupLocationInfo zzajp;

    public static PopupManager zza(GamesClientImpl gamesClientImpl, int n) {
        if (zzic.zznf()) {
            return new PopupManagerHCMR1(gamesClientImpl, n);
        }
        return new PopupManager(gamesClientImpl, n);
    }

    private PopupManager(GamesClientImpl gamesClientImpl, int gravity) {
        this.zzajo = gamesClientImpl;
        this.zzeY(gravity);
    }

    protected void zzeY(int n) {
        this.zzajp = new PopupLocationInfo(n, (IBinder)new Binder());
    }

    public void setGravity(int gravity) {
        this.zzajp.gravity = gravity;
    }

    public void zzo(View view) {
    }

    public void zzrm() {
        this.zzajo.zza(this.zzajp.zzajq, this.zzajp.zzrl());
    }

    public Bundle zzrn() {
        return this.zzajp.zzrl();
    }

    public IBinder zzro() {
        return this.zzajp.zzajq;
    }

    public PopupLocationInfo zzrp() {
        return this.zzajp;
    }

    public static final class PopupLocationInfo {
        public IBinder zzajq;
        public int gravity;
        public int zzajr = -1;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        private PopupLocationInfo(int gravity, IBinder windowToken) {
            this.gravity = gravity;
            this.zzajq = windowToken;
        }

        public Bundle zzrl() {
            Bundle bundle = new Bundle();
            bundle.putInt("popupLocationInfo.gravity", this.gravity);
            bundle.putInt("popupLocationInfo.displayId", this.zzajr);
            bundle.putInt("popupLocationInfo.left", this.left);
            bundle.putInt("popupLocationInfo.top", this.top);
            bundle.putInt("popupLocationInfo.right", this.right);
            bundle.putInt("popupLocationInfo.bottom", this.bottom);
            return bundle;
        }
    }

    private static final class PopupManagerHCMR1
    extends PopupManager
    implements View.OnAttachStateChangeListener,
    ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<View> zzajs;
        private boolean zzahP = false;

        protected PopupManagerHCMR1(GamesClientImpl gamesClientImpl, int gravity) {
            super(gamesClientImpl, gravity);
        }

        @Override
        protected void zzeY(int n) {
            this.zzajp = new PopupLocationInfo(n, null);
        }

        @Override
        public void zzo(View view) {
            Context context;
            View view2;
            this.zzajo.zzra();
            if (this.zzajs != null) {
                view2 = (View)this.zzajs.get();
                context = this.zzajo.getContext();
                if (view2 == null && context instanceof Activity) {
                    view2 = ((Activity)context).getWindow().getDecorView();
                }
                if (view2 != null) {
                    view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewTreeObserver viewTreeObserver = view2.getViewTreeObserver();
                    if (zzic.zzni()) {
                        viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            }
            this.zzajs = null;
            view2 = this.zzajo.getContext();
            if (view == null && view2 instanceof Activity) {
                context = (Activity)view2;
                view = context.findViewById(0x1020002);
                if (view == null) {
                    view = ((Activity)view2).getWindow().getDecorView();
                }
                GamesLog.zzt("PopupManager", "You have not specified a View to use as content view for popups. Falling back to the Activity content view. Note that this may not work as expected in multi-screen environments");
            }
            if (view != null) {
                this.zzp(view);
                this.zzajs = new WeakReference<View>(view);
                view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                context = view.getViewTreeObserver();
                context.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                GamesLog.zzu("PopupManager", "No content view usable to display popups. Popups will not be displayed in response to this client's calls. Use setViewForPopups() to set your content view.");
            }
        }

        @Override
        public void zzrm() {
            if (this.zzajp.zzajq != null) {
                super.zzrm();
                return;
            }
            this.zzahP = this.zzajs != null;
        }

        public void onViewAttachedToWindow(View v) {
            this.zzp(v);
        }

        public void onViewDetachedFromWindow(View v) {
            this.zzajo.zzra();
            v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onGlobalLayout() {
            if (this.zzajs == null) {
                return;
            }
            View view = (View)this.zzajs.get();
            if (view == null) {
                return;
            }
            this.zzp(view);
        }

        private void zzp(View view) {
            Display display;
            int n = -1;
            if (zzic.zznj()) {
                display = view.getDisplay();
                n = display != null ? display.getDisplayId() : -1;
            }
            display = view.getWindowToken();
            int[] nArray = new int[2];
            view.getLocationInWindow(nArray);
            int n2 = view.getWidth();
            int n3 = view.getHeight();
            this.zzajp.zzajr = n;
            this.zzajp.zzajq = display;
            this.zzajp.left = nArray[0];
            this.zzajp.top = nArray[1];
            this.zzajp.right = nArray[0] + n2;
            this.zzajp.bottom = nArray[1] + n3;
            if (this.zzahP) {
                this.zzrm();
                this.zzahP = false;
            }
        }
    }
}

