/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.request;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.games.internal.constants.RequestUpdateResultOutcome;
import java.util.HashMap;
import java.util.Set;

public final class RequestUpdateOutcomes {
    private static final String[] zzamJ = new String[]{"requestId", "outcome"};
    private final int zzOJ;
    private final HashMap<String, Integer> zzamK;

    private RequestUpdateOutcomes(int statusCode, HashMap<String, Integer> outcomeMap) {
        this.zzOJ = statusCode;
        this.zzamK = outcomeMap;
    }

    public int getRequestOutcome(String requestId) {
        zzv.zzb((boolean)this.zzamK.containsKey(requestId), (Object)("Request " + requestId + " was not part of the update operation!"));
        return this.zzamK.get(requestId);
    }

    public Set<String> getRequestIds() {
        return this.zzamK.keySet();
    }

    public static RequestUpdateOutcomes zzX(DataHolder dataHolder) {
        Builder builder = new Builder();
        builder.zzfk(dataHolder.getStatusCode());
        int n = dataHolder.getCount();
        for (int i = 0; i < n; ++i) {
            int n2 = dataHolder.zzaD(i);
            builder.zzw(dataHolder.zzd("requestId", i, n2), dataHolder.zzc("outcome", i, n2));
        }
        return builder.zzrY();
    }

    public static final class Builder {
        private HashMap<String, Integer> zzamK = new HashMap();
        private int zzOJ = 0;

        public Builder zzw(String string, int n) {
            if (RequestUpdateResultOutcome.isValid(n)) {
                this.zzamK.put(string, n);
            }
            return this;
        }

        public Builder zzfk(int n) {
            this.zzOJ = n;
            return this;
        }

        public RequestUpdateOutcomes zzrY() {
            return new RequestUpdateOutcomes(this.zzOJ, this.zzamK);
        }
    }
}

