/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.zzhu;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final TurnBasedMatchEntityCreator CREATOR = new TurnBasedMatchEntityCreator();
    private final int zzzH;
    private final GameEntity zzalP;
    private final String zzaiA;
    private final String zzanM;
    private final long zzanq;
    private final String zzanU;
    private final long zzahd;
    private final String zzanV;
    private final int zzanW;
    private final int zzanu;
    private final int zzKu;
    private final byte[] zzanX;
    private final ArrayList<ParticipantEntity> zzant;
    private final String zzanY;
    private final byte[] zzanZ;
    private final int zzaoa;
    private final Bundle zzanK;
    private final int zzaob;
    private final boolean zzaoc;
    private final String zzadH;
    private final String zzaod;

    public TurnBasedMatchEntity(TurnBasedMatch match) {
        this.zzzH = 2;
        this.zzalP = new GameEntity(match.getGame());
        this.zzaiA = match.getMatchId();
        this.zzanM = match.getCreatorId();
        this.zzanq = match.getCreationTimestamp();
        this.zzanU = match.getLastUpdaterId();
        this.zzahd = match.getLastUpdatedTimestamp();
        this.zzanV = match.getPendingParticipantId();
        this.zzanW = match.getStatus();
        this.zzaob = match.getTurnStatus();
        this.zzanu = match.getVariant();
        this.zzKu = match.getVersion();
        this.zzanY = match.getRematchId();
        this.zzaoa = match.getMatchNumber();
        this.zzanK = match.getAutoMatchCriteria();
        this.zzaoc = match.isLocallyModified();
        this.zzadH = match.getDescription();
        this.zzaod = match.getDescriptionParticipantId();
        byte[] byArray = match.getData();
        if (byArray == null) {
            this.zzanX = null;
        } else {
            this.zzanX = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzanX, 0, byArray.length);
        }
        byte[] byArray2 = match.getPreviousMatchData();
        if (byArray2 == null) {
            this.zzanZ = null;
        } else {
            this.zzanZ = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.zzanZ, 0, byArray2.length);
        }
        ArrayList arrayList = match.getParticipants();
        int n = arrayList.size();
        this.zzant = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzant.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(int versionCode, GameEntity game, String matchId, String creatorId, long creationTimestamp, String lastUpdaterId, long lastUpdatedTimestamp, String pendingParticipantId, int matchStatus, int variant, int version, byte[] data, ArrayList<ParticipantEntity> participants, String rematchId, byte[] previousData, int matchNumber, Bundle autoMatchCriteria, int turnStatus, boolean isLocallyModified, String description, String descriptionParticipantId) {
        this.zzzH = versionCode;
        this.zzalP = game;
        this.zzaiA = matchId;
        this.zzanM = creatorId;
        this.zzanq = creationTimestamp;
        this.zzanU = lastUpdaterId;
        this.zzahd = lastUpdatedTimestamp;
        this.zzanV = pendingParticipantId;
        this.zzanW = matchStatus;
        this.zzaob = turnStatus;
        this.zzanu = variant;
        this.zzKu = version;
        this.zzanX = data;
        this.zzant = participants;
        this.zzanY = rematchId;
        this.zzanZ = previousData;
        this.zzaoa = matchNumber;
        this.zzanK = autoMatchCriteria;
        this.zzaoc = isLocallyModified;
        this.zzadH = description;
        this.zzaod = descriptionParticipantId;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public Game getGame() {
        return this.zzalP;
    }

    @Override
    public String getMatchId() {
        return this.zzaiA;
    }

    @Override
    public String getCreatorId() {
        return this.zzanM;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzanq;
    }

    @Override
    public String getLastUpdaterId() {
        return this.zzanU;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzahd;
    }

    @Override
    public String getPendingParticipantId() {
        return this.zzanV;
    }

    @Override
    public int getStatus() {
        return this.zzanW;
    }

    @Override
    public int getTurnStatus() {
        return this.zzaob;
    }

    @Override
    public String getDescription() {
        return this.zzadH;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.zzaod;
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string = this.getDescriptionParticipantId();
        if (string == null) {
            return null;
        }
        return this.getParticipant(string);
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzadH, (CharArrayBuffer)dataOut);
    }

    @Override
    public int getVariant() {
        return this.zzanu;
    }

    @Override
    public byte[] getData() {
        return this.zzanX;
    }

    @Override
    public int getVersion() {
        return this.zzKu;
    }

    @Override
    public String getRematchId() {
        return this.zzanY;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.zzanZ;
    }

    @Override
    public int getMatchNumber() {
        return this.zzaoa;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzanK;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.zzanK == null) {
            return 0;
        }
        return this.zzanK.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.zzanW == 2 && this.zzanY == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.zzaoc;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.zzb(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.zzc(this, participantId);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzant);
    }

    public TurnBasedMatch freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return zzu.hashCode((Object[])new Object[]{turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified()});
    }

    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, obj);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzu.equal((Object)turnBasedMatch2.getGame(), (Object)turnBasedMatch.getGame()) && zzu.equal((Object)turnBasedMatch2.getMatchId(), (Object)turnBasedMatch.getMatchId()) && zzu.equal((Object)turnBasedMatch2.getCreatorId(), (Object)turnBasedMatch.getCreatorId()) && zzu.equal((Object)turnBasedMatch2.getCreationTimestamp(), (Object)turnBasedMatch.getCreationTimestamp()) && zzu.equal((Object)turnBasedMatch2.getLastUpdaterId(), (Object)turnBasedMatch.getLastUpdaterId()) && zzu.equal((Object)turnBasedMatch2.getLastUpdatedTimestamp(), (Object)turnBasedMatch.getLastUpdatedTimestamp()) && zzu.equal((Object)turnBasedMatch2.getPendingParticipantId(), (Object)turnBasedMatch.getPendingParticipantId()) && zzu.equal((Object)turnBasedMatch2.getStatus(), (Object)turnBasedMatch.getStatus()) && zzu.equal((Object)turnBasedMatch2.getTurnStatus(), (Object)turnBasedMatch.getTurnStatus()) && zzu.equal((Object)turnBasedMatch2.getDescription(), (Object)turnBasedMatch.getDescription()) && zzu.equal((Object)turnBasedMatch2.getVariant(), (Object)turnBasedMatch.getVariant()) && zzu.equal((Object)turnBasedMatch2.getVersion(), (Object)turnBasedMatch.getVersion()) && zzu.equal((Object)turnBasedMatch2.getParticipants(), (Object)turnBasedMatch.getParticipants()) && zzu.equal((Object)turnBasedMatch2.getRematchId(), (Object)turnBasedMatch.getRematchId()) && zzu.equal((Object)turnBasedMatch2.getMatchNumber(), (Object)turnBasedMatch.getMatchNumber()) && zzu.equal((Object)turnBasedMatch2.getAutoMatchCriteria(), (Object)turnBasedMatch.getAutoMatchCriteria()) && zzu.equal((Object)turnBasedMatch2.getAvailableAutoMatchSlots(), (Object)turnBasedMatch.getAvailableAutoMatchSlots()) && zzu.equal((Object)turnBasedMatch2.isLocallyModified(), (Object)turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzu.zzq((Object)turnBasedMatch).zzg("Game", (Object)turnBasedMatch.getGame()).zzg("MatchId", (Object)turnBasedMatch.getMatchId()).zzg("CreatorId", (Object)turnBasedMatch.getCreatorId()).zzg("CreationTimestamp", (Object)turnBasedMatch.getCreationTimestamp()).zzg("LastUpdaterId", (Object)turnBasedMatch.getLastUpdaterId()).zzg("LastUpdatedTimestamp", (Object)turnBasedMatch.getLastUpdatedTimestamp()).zzg("PendingParticipantId", (Object)turnBasedMatch.getPendingParticipantId()).zzg("MatchStatus", (Object)turnBasedMatch.getStatus()).zzg("TurnStatus", (Object)turnBasedMatch.getTurnStatus()).zzg("Description", (Object)turnBasedMatch.getDescription()).zzg("Variant", (Object)turnBasedMatch.getVariant()).zzg("Data", (Object)turnBasedMatch.getData()).zzg("Version", (Object)turnBasedMatch.getVersion()).zzg("Participants", (Object)turnBasedMatch.getParticipants()).zzg("RematchId", (Object)turnBasedMatch.getRematchId()).zzg("PreviousData", (Object)turnBasedMatch.getPreviousMatchData()).zzg("MatchNumber", (Object)turnBasedMatch.getMatchNumber()).zzg("AutoMatchCriteria", (Object)turnBasedMatch.getAutoMatchCriteria()).zzg("AvailableAutoMatchSlots", (Object)turnBasedMatch.getAvailableAutoMatchSlots()).zzg("LocallyModified", (Object)turnBasedMatch.isLocallyModified()).zzg("DescriptionParticipantId", (Object)turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        TurnBasedMatchEntityCreator.zza(this, out, flags);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + turnBasedMatch.getMatchId());
    }
}

