/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.snapshot.Snapshot;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntity;
import com.google.android.gms.games.snapshot.SnapshotEntityCreator;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntity;

public final class SnapshotEntity
implements SafeParcelable,
Snapshot {
    public static final SnapshotEntityCreator CREATOR = new SnapshotEntityCreator();
    private final int zzzH;
    private final SnapshotMetadataEntity zzaow;
    private final SnapshotContentsEntity zzaox;

    public SnapshotEntity(SnapshotMetadata metadata, SnapshotContentsEntity contents) {
        this(2, metadata, contents);
    }

    SnapshotEntity(int versionCode, SnapshotMetadata metadata, SnapshotContentsEntity contents) {
        this.zzzH = versionCode;
        this.zzaow = new SnapshotMetadataEntity(metadata);
        this.zzaox = contents;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public SnapshotMetadata getMetadata() {
        return this.zzaow;
    }

    @Override
    public SnapshotContents getSnapshotContents() {
        return this.isClosed() ? null : this.zzaox;
    }

    private boolean isClosed() {
        return this.zzaox.isClosed();
    }

    public Snapshot freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotEntity.zzb(this);
    }

    static int zzb(Snapshot snapshot) {
        return zzu.hashCode((Object[])new Object[]{snapshot.getMetadata(), snapshot.getSnapshotContents()});
    }

    public boolean equals(Object obj) {
        return SnapshotEntity.zza(this, obj);
    }

    static boolean zza(Snapshot snapshot, Object object) {
        if (!(object instanceof Snapshot)) {
            return false;
        }
        if (snapshot == object) {
            return true;
        }
        Snapshot snapshot2 = (Snapshot)object;
        return zzu.equal((Object)snapshot2.getMetadata(), (Object)snapshot.getMetadata()) && zzu.equal((Object)snapshot2.getSnapshotContents(), (Object)snapshot.getSnapshotContents());
    }

    public String toString() {
        return SnapshotEntity.zzc(this);
    }

    static String zzc(Snapshot snapshot) {
        return zzu.zzq((Object)snapshot).zzg("Metadata", (Object)snapshot.getMetadata()).zzg("HasContents", (Object)(snapshot.getSnapshotContents() != null ? 1 : 0)).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotEntityCreator.zza(this, out, flags);
    }
}

