/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntityCreator;
import com.google.android.gms.internal.zzhu;

public final class SnapshotMetadataEntity
implements SafeParcelable,
SnapshotMetadata {
    public static final SnapshotMetadataEntityCreator CREATOR = new SnapshotMetadataEntityCreator();
    private final int zzzH;
    private final GameEntity zzalP;
    private final PlayerEntity zzaoE;
    private final String zzaia;
    private final Uri zzaoB;
    private final String zzaoF;
    private final String zzWn;
    private final String zzadH;
    private final long zzaoG;
    private final long zzaoH;
    private final float zzaoI;
    private final String zzaoJ;
    private final boolean zzaoK;
    private final long zzaoL;

    public SnapshotMetadataEntity(SnapshotMetadata snapshotMetadata) {
        this.zzzH = 5;
        this.zzalP = new GameEntity(snapshotMetadata.getGame());
        this.zzaoE = new PlayerEntity(snapshotMetadata.getOwner());
        this.zzaia = snapshotMetadata.getSnapshotId();
        this.zzaoB = snapshotMetadata.getCoverImageUri();
        this.zzaoF = snapshotMetadata.getCoverImageUrl();
        this.zzaoI = snapshotMetadata.getCoverImageAspectRatio();
        this.zzWn = snapshotMetadata.getTitle();
        this.zzadH = snapshotMetadata.getDescription();
        this.zzaoG = snapshotMetadata.getLastModifiedTimestamp();
        this.zzaoH = snapshotMetadata.getPlayedTime();
        this.zzaoJ = snapshotMetadata.getUniqueName();
        this.zzaoK = snapshotMetadata.hasChangePending();
        this.zzaoL = snapshotMetadata.getProgressValue();
    }

    SnapshotMetadataEntity(int versionCode, GameEntity game, PlayerEntity owner, String snapshotId, Uri coverImageUri, String coverImageUrl, String title, String description, long lastModifiedTimestamp, long playedTime, float coverImageAspectRatio, String uniqueName, boolean changePending, long progressValue) {
        this.zzzH = versionCode;
        this.zzalP = game;
        this.zzaoE = owner;
        this.zzaia = snapshotId;
        this.zzaoB = coverImageUri;
        this.zzaoF = coverImageUrl;
        this.zzaoI = coverImageAspectRatio;
        this.zzWn = title;
        this.zzadH = description;
        this.zzaoG = lastModifiedTimestamp;
        this.zzaoH = playedTime;
        this.zzaoJ = uniqueName;
        this.zzaoK = changePending;
        this.zzaoL = progressValue;
    }

    public int getVersionCode() {
        return this.zzzH;
    }

    @Override
    public Game getGame() {
        return this.zzalP;
    }

    @Override
    public Player getOwner() {
        return this.zzaoE;
    }

    @Override
    public String getSnapshotId() {
        return this.zzaia;
    }

    @Override
    public Uri getCoverImageUri() {
        return this.zzaoB;
    }

    @Override
    public String getCoverImageUrl() {
        return this.zzaoF;
    }

    @Override
    public float getCoverImageAspectRatio() {
        return this.zzaoI;
    }

    @Override
    public String getUniqueName() {
        return this.zzaoJ;
    }

    @Override
    public String getTitle() {
        return this.zzWn;
    }

    @Override
    public String getDescription() {
        return this.zzadH;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzhu.zzb((String)this.zzadH, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.zzaoG;
    }

    @Override
    public long getPlayedTime() {
        return this.zzaoH;
    }

    @Override
    public boolean hasChangePending() {
        return this.zzaoK;
    }

    @Override
    public long getProgressValue() {
        return this.zzaoL;
    }

    public SnapshotMetadata freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.zza(this);
    }

    static int zza(SnapshotMetadata snapshotMetadata) {
        return zzu.hashCode((Object[])new Object[]{snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.getTitle(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName(), snapshotMetadata.hasChangePending(), snapshotMetadata.getProgressValue()});
    }

    public boolean equals(Object obj) {
        return SnapshotMetadataEntity.zza(this, obj);
    }

    static boolean zza(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        SnapshotMetadata snapshotMetadata2 = (SnapshotMetadata)object;
        return zzu.equal((Object)snapshotMetadata2.getGame(), (Object)snapshotMetadata.getGame()) && zzu.equal((Object)snapshotMetadata2.getOwner(), (Object)snapshotMetadata.getOwner()) && zzu.equal((Object)snapshotMetadata2.getSnapshotId(), (Object)snapshotMetadata.getSnapshotId()) && zzu.equal((Object)snapshotMetadata2.getCoverImageUri(), (Object)snapshotMetadata.getCoverImageUri()) && zzu.equal((Object)Float.valueOf(snapshotMetadata2.getCoverImageAspectRatio()), (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && zzu.equal((Object)snapshotMetadata2.getTitle(), (Object)snapshotMetadata.getTitle()) && zzu.equal((Object)snapshotMetadata2.getDescription(), (Object)snapshotMetadata.getDescription()) && zzu.equal((Object)snapshotMetadata2.getLastModifiedTimestamp(), (Object)snapshotMetadata.getLastModifiedTimestamp()) && zzu.equal((Object)snapshotMetadata2.getPlayedTime(), (Object)snapshotMetadata.getPlayedTime()) && zzu.equal((Object)snapshotMetadata2.getUniqueName(), (Object)snapshotMetadata.getUniqueName()) && zzu.equal((Object)snapshotMetadata2.hasChangePending(), (Object)snapshotMetadata.hasChangePending()) && zzu.equal((Object)snapshotMetadata2.getProgressValue(), (Object)snapshotMetadata.getProgressValue());
    }

    public String toString() {
        return SnapshotMetadataEntity.zzb(this);
    }

    static String zzb(SnapshotMetadata snapshotMetadata) {
        return zzu.zzq((Object)snapshotMetadata).zzg("Game", (Object)snapshotMetadata.getGame()).zzg("Owner", (Object)snapshotMetadata.getOwner()).zzg("SnapshotId", (Object)snapshotMetadata.getSnapshotId()).zzg("CoverImageUri", (Object)snapshotMetadata.getCoverImageUri()).zzg("CoverImageUrl", (Object)snapshotMetadata.getCoverImageUrl()).zzg("CoverImageAspectRatio", (Object)Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).zzg("Description", (Object)snapshotMetadata.getDescription()).zzg("LastModifiedTimestamp", (Object)snapshotMetadata.getLastModifiedTimestamp()).zzg("PlayedTime", (Object)snapshotMetadata.getPlayedTime()).zzg("UniqueName", (Object)snapshotMetadata.getUniqueName()).zzg("ChangePending", (Object)snapshotMetadata.hasChangePending()).zzg("ProgressValue", (Object)snapshotMetadata.getProgressValue()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataEntityCreator.zza(this, out, flags);
    }
}

