/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;
import com.google.android.gms.internal.zzlc;

public final class AchievementEntity
implements SafeParcelable,
Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new AchievementEntityCreator();
    private final int zzCY;
    private final String zzanZ;
    private final int zzSq;
    private final String mName;
    private final String zzakM;
    private final Uri zzaoa;
    private final String zzaob;
    private final Uri zzaoc;
    private final String zzaod;
    private final int zzaoe;
    private final String zzaof;
    private final PlayerEntity zzaog;
    private final int mState;
    private final int zzaoh;
    private final String zzaoi;
    private final long zzaoj;
    private final long zzaok;

    public AchievementEntity(Achievement achievement) {
        this.zzCY = 1;
        this.zzanZ = achievement.getAchievementId();
        this.zzSq = achievement.getType();
        this.mName = achievement.getName();
        this.zzakM = achievement.getDescription();
        this.zzaoa = achievement.getUnlockedImageUri();
        this.zzaob = achievement.getUnlockedImageUrl();
        this.zzaoc = achievement.getRevealedImageUri();
        this.zzaod = achievement.getRevealedImageUrl();
        this.zzaog = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzaoj = achievement.getLastUpdatedTimestamp();
        this.zzaok = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzaoe = achievement.getTotalSteps();
            this.zzaof = achievement.getFormattedTotalSteps();
            this.zzaoh = achievement.getCurrentSteps();
            this.zzaoi = achievement.getFormattedCurrentSteps();
        } else {
            this.zzaoe = 0;
            this.zzaof = null;
            this.zzaoh = 0;
            this.zzaoi = null;
        }
        zzb.zzq((Object)this.zzanZ);
        zzb.zzq((Object)this.zzakM);
    }

    AchievementEntity(int versionCode, String achievementId, int type, String name, String description, Uri unlockedImageUri, String unlockedImageUrl, Uri revealedImageUri, String revealedImageUrl, int totalSteps, String formattedTotalSteps, PlayerEntity player, int state, int currentSteps, String formattedCurrentSteps, long lastUpdatedTimestamp, long xpValue) {
        this.zzCY = versionCode;
        this.zzanZ = achievementId;
        this.zzSq = type;
        this.mName = name;
        this.zzakM = description;
        this.zzaoa = unlockedImageUri;
        this.zzaob = unlockedImageUrl;
        this.zzaoc = revealedImageUri;
        this.zzaod = revealedImageUrl;
        this.zzaoe = totalSteps;
        this.zzaof = formattedTotalSteps;
        this.zzaog = player;
        this.mState = state;
        this.zzaoh = currentSteps;
        this.zzaoi = formattedCurrentSteps;
        this.zzaoj = lastUpdatedTimestamp;
        this.zzaok = xpValue;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public String getAchievementId() {
        return this.zzanZ;
    }

    @Override
    public int getType() {
        return this.zzSq;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzlc.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzakM;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlc.zzb((String)this.zzakM, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.zzaoa;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.zzaob;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.zzaoc;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.zzaod;
    }

    @Override
    public int getTotalSteps() {
        return this.zzaoe;
    }

    @Override
    public String getFormattedTotalSteps() {
        return this.zzaof;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer dataOut) {
        zzlc.zzb((String)this.zzaof, (CharArrayBuffer)dataOut);
    }

    @Override
    public Player getPlayer() {
        return this.zzaog;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        return this.zzaoh;
    }

    @Override
    public String getFormattedCurrentSteps() {
        return this.zzaoi;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer dataOut) {
        zzlc.zzb((String)this.zzaoi, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaoj;
    }

    @Override
    public long getXpValue() {
        return this.zzaok;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.zza(this);
    }

    static int zza(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return zzt.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object obj) {
        return AchievementEntity.zza(this, obj);
    }

    static boolean zza(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = zzt.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = zzt.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return zzt.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && zzt.equal((Object)achievement2.getName(), (Object)achievement.getName()) && zzt.equal((Object)achievement2.getType(), (Object)achievement.getType()) && zzt.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && zzt.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && zzt.equal((Object)achievement2.getState(), (Object)achievement.getState()) && zzt.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && zzt.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    static String zzb(Achievement achievement) {
        zzt.zza zza2 = zzt.zzt((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zza2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zza2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zza2.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AchievementEntityCreator.zza(this, dest, flags);
    }
}

