/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantEntity;
import com.google.android.gms.internal.zzlc;
import java.util.ArrayList;

public final class LeaderboardEntity
implements Leaderboard {
    private final String zzaty;
    private final String zzadI;
    private final Uri zzanf;
    private final int zzatz;
    private final ArrayList<LeaderboardVariantEntity> zzatA;
    private final Game zzatB;
    private final String zzanq;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.zzaty = leaderboard.getLeaderboardId();
        this.zzadI = leaderboard.getDisplayName();
        this.zzanf = leaderboard.getIconImageUri();
        this.zzanq = leaderboard.getIconImageUrl();
        this.zzatz = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.zzatB = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.zzatA = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzatA.add((LeaderboardVariantEntity)arrayList.get(i).freeze());
        }
    }

    @Override
    public String getLeaderboardId() {
        return this.zzaty;
    }

    @Override
    public String getDisplayName() {
        return this.zzadI;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzlc.zzb((String)this.zzadI, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzanf;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzanq;
    }

    @Override
    public int getScoreOrder() {
        return this.zzatz;
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.zzatA);
    }

    @Override
    public Game getGame() {
        return this.zzatB;
    }

    public Leaderboard zztE() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return zzt.hashCode((Object[])new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public boolean equals(Object obj) {
        return LeaderboardEntity.zza(this, obj);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzt.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzt.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzt.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzt.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzt.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzt.zzt((Object)leaderboard).zzg("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zzg("DisplayName", (Object)leaderboard.getDisplayName()).zzg("IconImageUri", (Object)leaderboard.getIconImageUri()).zzg("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zzg("ScoreOrder", (Object)leaderboard.getScoreOrder()).zzg("Variants", leaderboard.getVariants()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zztE();
    }
}

