/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int zzCY;
    private final GameEntity zzaud;
    private final String zzapl;
    private final long zzaue;
    private final int zzauf;
    private final ParticipantEntity zzaug;
    private final ArrayList<ParticipantEntity> zzauh;
    private final int zzaui;
    private final int zzauj;

    InvitationEntity(Invitation invitation) {
        this.zzCY = 2;
        this.zzaud = new GameEntity(invitation.getGame());
        this.zzapl = invitation.getInvitationId();
        this.zzaue = invitation.getCreationTimestamp();
        this.zzauf = invitation.getInvitationType();
        this.zzaui = invitation.getVariant();
        this.zzauj = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.zzauh = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.zzauh.add((ParticipantEntity)participant2.freeze());
        }
        zzu.zzb(participant, (Object)"Must have a valid inviter!");
        this.zzaug = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant, int availableAutoMatchSlots) {
        this.zzCY = versionCode;
        this.zzaud = game;
        this.zzapl = invitationId;
        this.zzaue = creationTimestamp;
        this.zzauf = invitationType;
        this.zzaug = inviter;
        this.zzauh = participants;
        this.zzaui = variant;
        this.zzauj = availableAutoMatchSlots;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public Game getGame() {
        return this.zzaud;
    }

    @Override
    public String getInvitationId() {
        return this.zzapl;
    }

    @Override
    public Participant getInviter() {
        return this.zzaug;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaue;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzauh);
    }

    @Override
    public int getInvitationType() {
        return this.zzauf;
    }

    @Override
    public int getVariant() {
        return this.zzaui;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.zzauj;
    }

    public Invitation freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return zzt.hashCode((Object[])new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public boolean equals(Object obj) {
        return InvitationEntity.zza(this, obj);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzt.equal((Object)invitation2.getGame(), (Object)invitation.getGame()) && zzt.equal((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && zzt.equal((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && zzt.equal((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && zzt.equal((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && zzt.equal((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && zzt.equal((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && zzt.equal((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzt.zzt((Object)invitation).zzg("Game", (Object)invitation.getGame()).zzg("InvitationId", (Object)invitation.getInvitationId()).zzg("CreationTimestamp", (Object)invitation.getCreationTimestamp()).zzg("InvitationType", (Object)invitation.getInvitationType()).zzg("Inviter", (Object)invitation.getInviter()).zzg("Participants", (Object)invitation.getParticipants()).zzg("Variant", (Object)invitation.getVariant()).zzg("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zznF()) {
            InvitationEntityCreator.zza(this, dest, flags);
        } else {
            this.zzaud.writeToParcel(dest, flags);
            dest.writeString(this.zzapl);
            dest.writeLong(this.zzaue);
            dest.writeInt(this.zzauf);
            this.zzaug.writeToParcel(dest, flags);
            int n = this.zzauh.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.zzauh.get(i).writeToParcel(dest, flags);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity zzdI(Parcel parcel) {
            int n;
            boolean bl = InvitationEntity.zzd(InvitationEntity.zznE());
            if (bl || InvitationEntity.zzca((String)InvitationEntity.class.getCanonicalName())) {
                return super.zzdI(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (n = 0; n < n3; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            int n4 = 0;
            return new InvitationEntity(2, gameEntity, string, l, n2, participantEntity, arrayList, n, n4);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdI(x0);
        }
    }
}

