/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.internal.zzlc;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int zzCY;
    private final String zzapO;
    private final String zzadI;
    private final Uri zzanf;
    private final Uri zzang;
    private final int zzwS;
    private final String zzaoO;
    private final boolean zzaul;
    private final PlayerEntity zzaog;
    private final int zzQT;
    private final ParticipantResult zzaum;
    private final String zzanq;
    private final String zzanr;

    public ParticipantEntity(Participant participant) {
        this.zzCY = 3;
        this.zzapO = participant.getParticipantId();
        this.zzadI = participant.getDisplayName();
        this.zzanf = participant.getIconImageUri();
        this.zzang = participant.getHiResImageUri();
        this.zzwS = participant.getStatus();
        this.zzaoO = participant.zzsr();
        this.zzaul = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzaog = player == null ? null : new PlayerEntity(player);
        this.zzQT = participant.getCapabilities();
        this.zzaum = participant.getResult();
        this.zzanq = participant.getIconImageUrl();
        this.zzanr = participant.getHiResImageUrl();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result, String iconImageUrl, String hiResImageUrl) {
        this.zzCY = versionCode;
        this.zzapO = participantId;
        this.zzadI = displayName;
        this.zzanf = iconImageUri;
        this.zzang = hiResImageUri;
        this.zzwS = status;
        this.zzaoO = clientAddress;
        this.zzaul = connectedToRoom;
        this.zzaog = player;
        this.zzQT = capabilities;
        this.zzaum = result;
        this.zzanq = iconImageUrl;
        this.zzanr = hiResImageUrl;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public int getStatus() {
        return this.zzwS;
    }

    @Override
    public String zzsr() {
        return this.zzaoO;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.zzaul;
    }

    @Override
    public String getDisplayName() {
        if (this.zzaog == null) {
            return this.zzadI;
        }
        return this.zzaog.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.zzaog == null) {
            zzlc.zzb((String)this.zzadI, (CharArrayBuffer)dataOut);
            return;
        }
        this.zzaog.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.zzaog == null) {
            return this.zzanf;
        }
        return this.zzaog.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.zzaog == null) {
            return this.zzanq;
        }
        return this.zzaog.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.zzaog == null) {
            return this.zzang;
        }
        return this.zzaog.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.zzaog == null) {
            return this.zzanr;
        }
        return this.zzaog.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.zzapO;
    }

    @Override
    public Player getPlayer() {
        return this.zzaog;
    }

    @Override
    public ParticipantResult getResult() {
        return this.zzaum;
    }

    @Override
    public int getCapabilities() {
        return this.zzQT;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return zzt.hashCode((Object[])new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzsr(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.zza(this, obj);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzt.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzt.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzt.equal((Object)participant2.zzsr(), (Object)participant.zzsr()) && zzt.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzt.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzt.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzt.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzt.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzt.equal((Object)participant2.getResult(), (Object)participant.getResult()) && zzt.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzt.zzt((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzsr()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zznF()) {
            ParticipantEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzapO);
            dest.writeString(this.zzadI);
            dest.writeString(this.zzanf == null ? null : this.zzanf.toString());
            dest.writeString(this.zzang == null ? null : this.zzang.toString());
            dest.writeInt(this.zzwS);
            dest.writeString(this.zzaoO);
            dest.writeInt(this.zzaul ? 1 : 0);
            dest.writeInt(this.zzaog == null ? 0 : 1);
            if (this.zzaog != null) {
                this.zzaog.writeToParcel(dest, flags);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity zzdJ(Parcel parcel) {
            boolean bl = ParticipantEntity.zzd(ParticipantEntity.zznE());
            if (bl || ParticipantEntity.zzca((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzdJ(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            int n2 = 7;
            ParticipantResult participantResult = null;
            String string6 = null;
            String string7 = null;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string, string2, uri, uri2, n, string5, bl2, playerEntity, n2, participantResult, string6, string7);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdJ(x0);
        }
    }
}

