/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import com.google.android.gms.internal.zzlc;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
implements SafeParcelable,
Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new QuestEntityCreator();
    private final int zzCY;
    private final GameEntity zzaud;
    private final String zzauV;
    private final long zzauW;
    private final Uri zzauX;
    private final String zzauY;
    private final String zzakM;
    private final long zzauZ;
    private final long zzaoj;
    private final Uri zzava;
    private final String zzavb;
    private final String mName;
    private final long zzavc;
    private final long zzavd;
    private final int mState;
    private final int zzSq;
    private final ArrayList<MilestoneEntity> zzave;

    public QuestEntity(Quest quest) {
        this.zzCY = 2;
        this.zzaud = new GameEntity(quest.getGame());
        this.zzauV = quest.getQuestId();
        this.zzauW = quest.getAcceptedTimestamp();
        this.zzakM = quest.getDescription();
        this.zzauX = quest.getBannerImageUri();
        this.zzauY = quest.getBannerImageUrl();
        this.zzauZ = quest.getEndTimestamp();
        this.zzava = quest.getIconImageUri();
        this.zzavb = quest.getIconImageUrl();
        this.zzaoj = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzavc = quest.zztO();
        this.zzavd = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzSq = quest.getType();
        List<Milestone> list = quest.zztN();
        int n = list.size();
        this.zzave = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzave.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(int versionCode, GameEntity game, String questId, long acceptedTimestamp, Uri bannerImageUri, String bannerImageUrl, String description, long endTimestamp, long lastUpdatedTimestamp, Uri iconImageUri, String iconImageUrl, String name, long notifyTimestamp, long startTimestamp, int state, int type, ArrayList<MilestoneEntity> milestones) {
        this.zzCY = versionCode;
        this.zzaud = game;
        this.zzauV = questId;
        this.zzauW = acceptedTimestamp;
        this.zzauX = bannerImageUri;
        this.zzauY = bannerImageUrl;
        this.zzakM = description;
        this.zzauZ = endTimestamp;
        this.zzaoj = lastUpdatedTimestamp;
        this.zzava = iconImageUri;
        this.zzavb = iconImageUrl;
        this.mName = name;
        this.zzavc = notifyTimestamp;
        this.zzavd = startTimestamp;
        this.mState = state;
        this.zzSq = type;
        this.zzave = milestones;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public String getQuestId() {
        return this.zzauV;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzlc.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzakM;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlc.zzb((String)this.zzakM, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzava;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzavb;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.zzauX;
    }

    @Override
    public String getBannerImageUrl() {
        return this.zzauY;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zztN().get(0);
    }

    @Override
    public List<Milestone> zztN() {
        return new ArrayList<Milestone>(this.zzave);
    }

    @Override
    public Game getGame() {
        return this.zzaud;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.zzSq;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.zzauW;
    }

    @Override
    public long getEndTimestamp() {
        return this.zzauZ;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaoj;
    }

    @Override
    public long zztO() {
        return this.zzavc;
    }

    @Override
    public long getStartTimestamp() {
        return this.zzavd;
    }

    @Override
    public boolean isEndingSoon() {
        return this.zzavc <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return zzt.hashCode((Object[])new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zztN(), quest.getName(), quest.zztO(), quest.getStartTimestamp(), quest.getState()});
    }

    public boolean equals(Object obj) {
        return QuestEntity.zza(this, obj);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzt.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzt.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzt.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzt.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzt.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzt.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzt.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzt.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzt.equal(quest2.zztN(), quest.zztN()) && zzt.equal((Object)quest2.getName(), (Object)quest.getName()) && zzt.equal((Object)quest2.zztO(), (Object)quest.zztO()) && zzt.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzt.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzt.zzt((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zztN()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zztO()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        QuestEntityCreator.zza(this, out, flags);
    }
}

