/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer zzaAY;
    private final TurnBasedMatchBuffer zzaAZ;
    private final TurnBasedMatchBuffer zzaBa;
    private final TurnBasedMatchBuffer zzaBb;

    public LoadMatchesResponse(Bundle matchData) {
        DataHolder dataHolder = LoadMatchesResponse.zza(matchData, 0);
        this.zzaAY = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.zza(matchData, 1);
        this.zzaAZ = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.zza(matchData, 2);
        this.zzaBa = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.zza(matchData, 3);
        this.zzaBb = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder zza(Bundle bundle, int n) {
        String string = TurnBasedMatchTurnStatus.zzfZ(n);
        if (!bundle.containsKey(string)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string);
    }

    public InvitationBuffer getInvitations() {
        return this.zzaAY;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.zzaAZ;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.zzaBa;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.zzaBb;
    }

    @Deprecated
    public void close() {
        this.release();
    }

    public void release() {
        if (this.zzaAY != null) {
            this.zzaAY.release();
        }
        if (this.zzaAZ != null) {
            this.zzaAZ.release();
        }
        if (this.zzaBa != null) {
            this.zzaBa.release();
        }
        if (this.zzaBb != null) {
            this.zzaBb.release();
        }
    }

    public boolean hasData() {
        if (this.zzaAY != null && this.zzaAY.getCount() > 0) {
            return true;
        }
        if (this.zzaAZ != null && this.zzaAZ.getCount() > 0) {
            return true;
        }
        if (this.zzaBa != null && this.zzaBa.getCount() > 0) {
            return true;
        }
        return this.zzaBb != null && this.zzaBb.getCount() > 0;
    }
}

