/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.appcontent.AppContents;
import com.google.android.gms.games.event.Events;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.api.AchievementsImpl;
import com.google.android.gms.games.internal.api.AclsImpl;
import com.google.android.gms.games.internal.api.AppContentsImpl;
import com.google.android.gms.games.internal.api.EventsImpl;
import com.google.android.gms.games.internal.api.GamesMetadataImpl;
import com.google.android.gms.games.internal.api.InvitationsImpl;
import com.google.android.gms.games.internal.api.LeaderboardsImpl;
import com.google.android.gms.games.internal.api.MultiplayerImpl;
import com.google.android.gms.games.internal.api.NotificationsImpl;
import com.google.android.gms.games.internal.api.PlayersImpl;
import com.google.android.gms.games.internal.api.QuestsImpl;
import com.google.android.gms.games.internal.api.RealTimeMultiplayerImpl;
import com.google.android.gms.games.internal.api.RequestsImpl;
import com.google.android.gms.games.internal.api.SnapshotsImpl;
import com.google.android.gms.games.internal.api.StatsImpl;
import com.google.android.gms.games.internal.api.TurnBasedMultiplayerImpl;
import com.google.android.gms.games.internal.api.VideosImpl;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.quest.Quests;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.games.snapshot.Snapshots;
import com.google.android.gms.games.stats.Stats;
import com.google.android.gms.games.video.Videos;
import com.google.android.gms.internal.zzlx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Games {
    public static final String EXTRA_PLAYER_IDS = "players";
    public static final String EXTRA_STATUS = "status";
    static final Api.zzc<GamesClientImpl> zzTo = new Api.zzc();
    private static final Api.zza<GamesClientImpl, GamesOptions> zzTp = new GamesClientBuilder(){

        public List<Scope> zza(GamesOptions gamesOptions) {
            return Collections.singletonList(SCOPE_GAMES);
        }

        public /* synthetic */ List zzn(Object object) {
            return this.zza((GamesOptions)object);
        }
    };
    private static final Api.zza<GamesClientImpl, GamesOptions> zzazU = new GamesClientBuilder(){

        public List<Scope> zza(GamesOptions gamesOptions) {
            return Collections.singletonList(zzazV);
        }

        public /* synthetic */ List zzn(Object object) {
            return this.zza((GamesOptions)object);
        }
    };
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final Api<GamesOptions> API = new Api("Games.API", zzTp, zzTo);
    public static final Scope zzazV = new Scope("https://www.googleapis.com/auth/games.firstparty");
    public static final Api<GamesOptions> zzazW = new Api("Games.API_1P", zzazU, zzTo);
    public static final GamesMetadata GamesMetadata = new GamesMetadataImpl();
    public static final Achievements Achievements = new AchievementsImpl();
    public static final AppContents zzazX = new AppContentsImpl();
    public static final Events Events = new EventsImpl();
    public static final Leaderboards Leaderboards = new LeaderboardsImpl();
    public static final Invitations Invitations = new InvitationsImpl();
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new TurnBasedMultiplayerImpl();
    public static final RealTimeMultiplayer RealTimeMultiplayer = new RealTimeMultiplayerImpl();
    public static final Multiplayer zzazY = new MultiplayerImpl();
    public static final Players Players = new PlayersImpl();
    public static final Notifications Notifications = new NotificationsImpl();
    public static final Quests Quests = new QuestsImpl();
    public static final Requests Requests = new RequestsImpl();
    public static final Snapshots Snapshots = new SnapshotsImpl();
    public static final Stats Stats = new StatsImpl();
    public static final Videos zzazZ = new VideosImpl();
    public static final Acls zzaAa = new AclsImpl();

    private Games() {
    }

    public static GamesClientImpl zzf(GoogleApiClient googleApiClient) {
        return Games.zzb(googleApiClient, true);
    }

    public static GamesClientImpl zzb(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzx.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return Games.zzc(googleApiClient, bl);
    }

    public static GamesClientImpl zzc(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zza((boolean)googleApiClient.zza(API), (Object)"GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Games.API and is not connected to Games. Use GoogleApiClient.hasConnectedApi(Games.API) to guard this call.");
        }
        return bl2 ? (GamesClientImpl)googleApiClient.zza(zzTo) : null;
    }

    public static void setGravityForPopups(GoogleApiClient apiClient, int gravity) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzgk(gravity);
        }
    }

    public static void setViewForPopups(GoogleApiClient apiClient, View gamesContentView) {
        zzx.zzy((Object)gamesContentView);
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzo(gamesContentView);
        }
    }

    public static String getCurrentAccountName(GoogleApiClient apiClient) {
        return Games.zzf(apiClient).zzvR();
    }

    public static String getAppId(GoogleApiClient apiClient) {
        return Games.zzf(apiClient).zzwg();
    }

    public static Intent getSettingsIntent(GoogleApiClient apiClient) {
        return Games.zzf(apiClient).zzwe();
    }

    public static PendingResult<Status> signOut(GoogleApiClient apiClient) {
        return apiClient.zzb((zzlx.zza)new SignOutImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzf((zzlx.zzb<Status>)this);
            }
        });
    }

    public static int getSdkVariant(GoogleApiClient apiClient) {
        return Games.zzf(apiClient).zzwf();
    }

    private static abstract class SignOutImpl
    extends BaseGamesApiMethodImpl<Status> {
        private SignOutImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzb(Status status) {
            return status;
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class GetTokenImpl
    extends BaseGamesApiMethodImpl<GetTokenResult> {
        public GetTokenResult zzX(final Status status) {
            return new GetTokenResult(){

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzX(status);
        }
    }

    public static interface GetTokenResult
    extends Result {
    }

    public static abstract class BaseGamesApiMethodImpl<R extends Result>
    extends zzlx.zza<R, GamesClientImpl> {
        public BaseGamesApiMethodImpl(GoogleApiClient googleApiClient) {
            super(zzTo, googleApiClient);
        }
    }

    private static abstract class GamesClientBuilder
    extends Api.zza<GamesClientImpl, GamesOptions> {
        private GamesClientBuilder() {
        }

        public GamesClientImpl zza(Context context, Looper looper, zzf zzf2, GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (gamesOptions == null) {
                gamesOptions = new GamesOptions();
            }
            return new GamesClientImpl(context, looper, zzf2, gamesOptions, connectionCallbacks, onConnectionFailedListener);
        }

        public int getPriority() {
            return 1;
        }
    }

    public static final class GamesOptions
    implements Api.ApiOptions.Optional {
        public final boolean zzaAb;
        public final boolean zzaAc;
        public final int zzaAd;
        public final boolean zzaAe;
        public final int zzaAf;
        public final String zzaAg;
        public final ArrayList<String> zzaAh;

        private GamesOptions() {
            this.zzaAb = false;
            this.zzaAc = true;
            this.zzaAd = 17;
            this.zzaAe = false;
            this.zzaAf = 4368;
            this.zzaAg = null;
            this.zzaAh = new ArrayList();
        }

        private GamesOptions(Builder builder) {
            this.zzaAb = builder.zzaAb;
            this.zzaAc = builder.zzaAc;
            this.zzaAd = builder.zzaAd;
            this.zzaAe = builder.zzaAe;
            this.zzaAf = builder.zzaAf;
            this.zzaAg = builder.zzaAg;
            this.zzaAh = builder.zzaAh;
        }

        public Bundle zzuX() {
            Bundle bundle = new Bundle();
            bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.zzaAb);
            bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.zzaAc);
            bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.zzaAd);
            bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.zzaAe);
            bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.zzaAf);
            bundle.putString("com.google.android.gms.games.key.forceResolveAccountKey", this.zzaAg);
            bundle.putStringArrayList("com.google.android.gms.games.key.proxyApis", this.zzaAh);
            return bundle;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            boolean zzaAb = false;
            boolean zzaAc = true;
            int zzaAd = 17;
            boolean zzaAe = false;
            int zzaAf = 4368;
            String zzaAg = null;
            ArrayList<String> zzaAh = new ArrayList();

            private Builder() {
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup) {
                this.zzaAc = showConnectingPopup;
                this.zzaAd = 17;
                return this;
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup, int gravity) {
                this.zzaAc = showConnectingPopup;
                this.zzaAd = gravity;
                return this;
            }

            public Builder setSdkVariant(int variant) {
                this.zzaAf = variant;
                return this;
            }

            public GamesOptions build() {
                return new GamesOptions(this);
            }
        }
    }
}

