/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;
import com.google.android.gms.internal.zznn;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzabq;
    private final String zzVu;
    private final Uri zzazC;
    private final Uri zzazD;
    private final long zzaAj;
    private final int zzaAk;
    private final long zzaAl;
    private final String zzazN;
    private final String zzazO;
    private final String zzank;
    private final MostRecentGameInfoEntity zzaAm;
    private final PlayerLevelInfo zzaAn;
    private final boolean zzaAo;
    private final boolean zzaAp;
    private final String zzaAq;
    private final String mName;
    private final Uri zzaAr;
    private final String zzaAs;
    private final Uri zzaAt;
    private final String zzaAu;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    public PlayerEntity(Player player, boolean isPlusEnabled) {
        this.mVersionCode = 13;
        this.zzabq = isPlusEnabled ? player.getPlayerId() : null;
        this.zzVu = player.getDisplayName();
        this.zzazC = player.getIconImageUri();
        this.zzazN = player.getIconImageUrl();
        this.zzazD = player.getHiResImageUri();
        this.zzazO = player.getHiResImageUrl();
        this.zzaAj = player.getRetrievedTimestamp();
        this.zzaAk = player.zzva();
        this.zzaAl = player.getLastPlayedWithTimestamp();
        this.zzank = player.getTitle();
        this.zzaAo = player.zzvb();
        MostRecentGameInfo mostRecentGameInfo = player.zzvc();
        this.zzaAm = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.zzaAn = player.getLevelInfo();
        this.zzaAp = player.zzuZ();
        this.zzaAq = player.zzuY();
        this.mName = player.getName();
        this.zzaAr = player.getBannerImageLandscapeUri();
        this.zzaAs = player.getBannerImageLandscapeUrl();
        this.zzaAt = player.getBannerImagePortraitUri();
        this.zzaAu = player.getBannerImagePortraitUrl();
        if (isPlusEnabled) {
            zzb.zzu((Object)this.zzabq);
        }
        zzb.zzu((Object)this.zzVu);
        zzb.zzaa((this.zzaAj > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp, String iconImageUrl, String hiResImageUrl, String title, MostRecentGameInfoEntity mostRecentGameInfo, PlayerLevelInfo playerLevelInfo, boolean isProfileVisible, boolean hasDebugAccess, String gamerTag, String name, Uri bannerImageLandscapeUri, String bannerImageLandscapeUrl, Uri bannerImagePortraitUri, String bannerImagePortraitUrl) {
        this.mVersionCode = versionCode;
        this.zzabq = playerId;
        this.zzVu = displayName;
        this.zzazC = iconImageUri;
        this.zzazN = iconImageUrl;
        this.zzazD = hiResImageUri;
        this.zzazO = hiResImageUrl;
        this.zzaAj = retrievedTimestamp;
        this.zzaAk = isInCircles;
        this.zzaAl = lastPlayedWithTimestamp;
        this.zzank = title;
        this.zzaAo = isProfileVisible;
        this.zzaAm = mostRecentGameInfo;
        this.zzaAn = playerLevelInfo;
        this.zzaAp = hasDebugAccess;
        this.zzaAq = gamerTag;
        this.mName = name;
        this.zzaAr = bannerImageLandscapeUri;
        this.zzaAs = bannerImageLandscapeUrl;
        this.zzaAt = bannerImagePortraitUri;
        this.zzaAu = bannerImagePortraitUrl;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getPlayerId() {
        return this.zzabq;
    }

    @Override
    public String getDisplayName() {
        return this.zzVu;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.zzVu, (CharArrayBuffer)dataOut);
    }

    @Override
    public String zzuY() {
        return this.zzaAq;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean zzuZ() {
        return this.zzaAp;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzazC;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzazN;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzazD;
    }

    @Override
    public String getHiResImageUrl() {
        return this.zzazO;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.zzaAj;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.zzaAl;
    }

    @Override
    public int zzva() {
        return this.zzaAk;
    }

    @Override
    public boolean zzvb() {
        return this.zzaAo;
    }

    @Override
    public String getTitle() {
        return this.zzank;
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.zzank, (CharArrayBuffer)dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzaAn;
    }

    @Override
    public MostRecentGameInfo zzvc() {
        return this.zzaAm;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.zzaAr;
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.zzaAs;
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.zzaAt;
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.zzaAu;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    static int zzb(Player player) {
        return zzw.hashCode((Object[])new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzuZ(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzuY(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri()});
    }

    public boolean equals(Object obj) {
        return PlayerEntity.zza(this, obj);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzw.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzw.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzw.equal((Object)player2.zzuZ(), (Object)player.zzuZ()) && zzw.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzw.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzw.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzw.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzw.equal((Object)player2.getLevelInfo(), (Object)player.getLevelInfo()) && zzw.equal((Object)player2.zzuY(), (Object)player.zzuY()) && zzw.equal((Object)player2.getName(), (Object)player.getName()) && zzw.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzw.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri());
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    static String zzc(Player player) {
        return zzw.zzx((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzuZ()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzuY()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzqk()) {
            PlayerEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzabq);
            dest.writeString(this.zzVu);
            dest.writeString(this.zzazC == null ? null : this.zzazC.toString());
            dest.writeString(this.zzazD == null ? null : this.zzazD.toString());
            dest.writeLong(this.zzaAj);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity zzdT(Parcel parcel) {
            boolean bl = PlayerEntity.zzd(PlayerEntity.zzqj());
            if (bl || PlayerEntity.zzcz((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzdT(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            int n = -1;
            long l2 = -1L;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            PlayerLevelInfo playerLevelInfo = null;
            MostRecentGameInfoEntity mostRecentGameInfoEntity = null;
            boolean bl2 = true;
            boolean bl3 = false;
            Uri uri3 = null;
            String string10 = null;
            Uri uri4 = null;
            String string11 = null;
            return new PlayerEntity(13, string, string2, uri, uri2, l, n, l2, string7, string8, string9, mostRecentGameInfoEntity, playerLevelInfo, bl2, bl3, string5, string6, uri3, string10, uri4, string11);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdT(x0);
        }
    }
}

