/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.PlayerLevelCreator;

public final class PlayerLevel
implements SafeParcelable {
    public static final Parcelable.Creator<PlayerLevel> CREATOR = new PlayerLevelCreator();
    private final int mVersionCode;
    private final int zzaAv;
    private final long zzaAw;
    private final long zzaAx;

    public PlayerLevel(int value, long minXp, long maxXp) {
        this(1, value, minXp, maxXp);
    }

    PlayerLevel(int versionCode, int levelNumber, long minXp, long maxXp) {
        zzx.zza((minXp >= 0L ? 1 : 0) != 0, (Object)"Min XP must be positive!");
        zzx.zza((maxXp > minXp ? 1 : 0) != 0, (Object)"Max XP must be more than min XP!");
        this.mVersionCode = versionCode;
        this.zzaAv = levelNumber;
        this.zzaAw = minXp;
        this.zzaAx = maxXp;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int getLevelNumber() {
        return this.zzaAv;
    }

    public long getMinXp() {
        return this.zzaAw;
    }

    public long getMaxXp() {
        return this.zzaAx;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzaAv, this.zzaAw, this.zzaAx});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevel)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PlayerLevel playerLevel = (PlayerLevel)obj;
        return zzw.equal((Object)playerLevel.getLevelNumber(), (Object)this.getLevelNumber()) && zzw.equal((Object)playerLevel.getMinXp(), (Object)this.getMinXp()) && zzw.equal((Object)playerLevel.getMaxXp(), (Object)this.getMaxXp());
    }

    public String toString() {
        return zzw.zzx((Object)this).zzg("LevelNumber", (Object)this.getLevelNumber()).zzg("MinXp", (Object)this.getMinXp()).zzg("MaxXp", (Object)this.getMaxXp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelCreator.zza(this, out, flags);
    }
}

