/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfoCreator;

public final class PlayerLevelInfo
implements SafeParcelable {
    public static final Parcelable.Creator<PlayerLevelInfo> CREATOR = new PlayerLevelInfoCreator();
    private final int mVersionCode;
    private final long zzaAy;
    private final long zzaAz;
    private final PlayerLevel zzaAA;
    private final PlayerLevel zzaAB;

    public PlayerLevelInfo(long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        this(1, currentXpTotal, lastLevelUpTimestamp, currentLevel, nextLevel);
    }

    PlayerLevelInfo(int versionCode, long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        zzx.zzaa((currentXpTotal != -1L ? 1 : 0) != 0);
        zzx.zzy((Object)currentLevel);
        zzx.zzy((Object)nextLevel);
        this.mVersionCode = versionCode;
        this.zzaAy = currentXpTotal;
        this.zzaAz = lastLevelUpTimestamp;
        this.zzaAA = currentLevel;
        this.zzaAB = nextLevel;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public long getCurrentXpTotal() {
        return this.zzaAy;
    }

    public long getLastLevelUpTimestamp() {
        return this.zzaAz;
    }

    public PlayerLevel getCurrentLevel() {
        return this.zzaAA;
    }

    public PlayerLevel getNextLevel() {
        return this.zzaAB;
    }

    public boolean isMaxLevel() {
        return this.zzaAA.equals(this.zzaAB);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevelInfo)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PlayerLevelInfo playerLevelInfo = (PlayerLevelInfo)obj;
        return zzw.equal((Object)this.zzaAy, (Object)playerLevelInfo.zzaAy) && zzw.equal((Object)this.zzaAz, (Object)playerLevelInfo.zzaAz) && zzw.equal((Object)this.zzaAA, (Object)playerLevelInfo.zzaAA) && zzw.equal((Object)this.zzaAB, (Object)playerLevelInfo.zzaAB);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzaAy, this.zzaAz, this.zzaAA, this.zzaAB});
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelInfoCreator.zza(this, out, flags);
    }
}

