/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;
import com.google.android.gms.internal.zznn;

public final class AchievementEntity
implements SafeParcelable,
Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new AchievementEntityCreator();
    private final int mVersionCode;
    private final String zzaAE;
    private final int zzZU;
    private final String mName;
    private final String zzavc;
    private final Uri zzaAF;
    private final String zzaAG;
    private final Uri zzaAH;
    private final String zzaAI;
    private final int zzaAJ;
    private final String zzaAK;
    private final PlayerEntity zzaAL;
    private final int mState;
    private final int zzaAM;
    private final String zzaAN;
    private final long zzaAO;
    private final long zzaAP;

    public AchievementEntity(Achievement achievement) {
        this.mVersionCode = 1;
        this.zzaAE = achievement.getAchievementId();
        this.zzZU = achievement.getType();
        this.mName = achievement.getName();
        this.zzavc = achievement.getDescription();
        this.zzaAF = achievement.getUnlockedImageUri();
        this.zzaAG = achievement.getUnlockedImageUrl();
        this.zzaAH = achievement.getRevealedImageUri();
        this.zzaAI = achievement.getRevealedImageUrl();
        this.zzaAL = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzaAO = achievement.getLastUpdatedTimestamp();
        this.zzaAP = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzaAJ = achievement.getTotalSteps();
            this.zzaAK = achievement.getFormattedTotalSteps();
            this.zzaAM = achievement.getCurrentSteps();
            this.zzaAN = achievement.getFormattedCurrentSteps();
        } else {
            this.zzaAJ = 0;
            this.zzaAK = null;
            this.zzaAM = 0;
            this.zzaAN = null;
        }
        zzb.zzu((Object)this.zzaAE);
        zzb.zzu((Object)this.zzavc);
    }

    AchievementEntity(int versionCode, String achievementId, int type, String name, String description, Uri unlockedImageUri, String unlockedImageUrl, Uri revealedImageUri, String revealedImageUrl, int totalSteps, String formattedTotalSteps, PlayerEntity player, int state, int currentSteps, String formattedCurrentSteps, long lastUpdatedTimestamp, long xpValue) {
        this.mVersionCode = versionCode;
        this.zzaAE = achievementId;
        this.zzZU = type;
        this.mName = name;
        this.zzavc = description;
        this.zzaAF = unlockedImageUri;
        this.zzaAG = unlockedImageUrl;
        this.zzaAH = revealedImageUri;
        this.zzaAI = revealedImageUrl;
        this.zzaAJ = totalSteps;
        this.zzaAK = formattedTotalSteps;
        this.zzaAL = player;
        this.mState = state;
        this.zzaAM = currentSteps;
        this.zzaAN = formattedCurrentSteps;
        this.zzaAO = lastUpdatedTimestamp;
        this.zzaAP = xpValue;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getAchievementId() {
        return this.zzaAE;
    }

    @Override
    public int getType() {
        return this.zzZU;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzavc;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.zzavc, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.zzaAF;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.zzaAG;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.zzaAH;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.zzaAI;
    }

    public int zzve() {
        return this.zzaAJ;
    }

    @Override
    public int getTotalSteps() {
        zzb.zzaa((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzve();
    }

    @Override
    public String getFormattedTotalSteps() {
        zzb.zzaa((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzvf();
    }

    public String zzvf() {
        return this.zzaAK;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer dataOut) {
        zzb.zzaa((this.getType() == 1 ? 1 : 0) != 0);
        zznn.zzb((String)this.zzaAK, (CharArrayBuffer)dataOut);
    }

    @Override
    public Player getPlayer() {
        return this.zzaAL;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        zzb.zzaa((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzvg();
    }

    public int zzvg() {
        return this.zzaAM;
    }

    @Override
    public String getFormattedCurrentSteps() {
        zzb.zzaa((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzvh();
    }

    public String zzvh() {
        return this.zzaAN;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer dataOut) {
        zzb.zzaa((this.getType() == 1 ? 1 : 0) != 0);
        zznn.zzb((String)this.zzaAN, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaAO;
    }

    @Override
    public long getXpValue() {
        return this.zzaAP;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.zza(this);
    }

    static int zza(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return zzw.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object obj) {
        return AchievementEntity.zza(this, obj);
    }

    static boolean zza(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = zzw.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = zzw.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return zzw.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && zzw.equal((Object)achievement2.getName(), (Object)achievement.getName()) && zzw.equal((Object)achievement2.getType(), (Object)achievement.getType()) && zzw.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && zzw.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && zzw.equal((Object)achievement2.getState(), (Object)achievement.getState()) && zzw.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && zzw.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    static String zzb(Achievement achievement) {
        zzw.zza zza2 = zzw.zzx((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zza2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zza2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zza2.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AchievementEntityCreator.zza(this, dest, flags);
    }
}

