/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;
import com.google.android.gms.internal.zznn;

public final class EventEntity
implements SafeParcelable,
Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int mVersionCode;
    private final String zzaBp;
    private final String mName;
    private final String zzavc;
    private final Uri zzazC;
    private final String zzazN;
    private final PlayerEntity zzaAL;
    private final long zzaBq;
    private final String zzaBr;
    private final boolean zzaBs;

    public EventEntity(Event event) {
        this.mVersionCode = 1;
        this.zzaBp = event.getEventId();
        this.mName = event.getName();
        this.zzavc = event.getDescription();
        this.zzazC = event.getIconImageUri();
        this.zzazN = event.getIconImageUrl();
        this.zzaAL = (PlayerEntity)event.getPlayer().freeze();
        this.zzaBq = event.getValue();
        this.zzaBr = event.getFormattedValue();
        this.zzaBs = event.isVisible();
    }

    EventEntity(int versionCode, String eventId, String name, String description, Uri iconImageUri, String iconImageUrl, Player player, long value, String formattedValue, boolean isVisible) {
        this.mVersionCode = versionCode;
        this.zzaBp = eventId;
        this.mName = name;
        this.zzavc = description;
        this.zzazC = iconImageUri;
        this.zzazN = iconImageUrl;
        this.zzaAL = new PlayerEntity(player);
        this.zzaBq = value;
        this.zzaBr = formattedValue;
        this.zzaBs = isVisible;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.zzaBp;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzavc;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.zzavc, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzazC;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzazN;
    }

    @Override
    public Player getPlayer() {
        return this.zzaAL;
    }

    @Override
    public long getValue() {
        return this.zzaBq;
    }

    @Override
    public String getFormattedValue() {
        return this.zzaBr;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.zzaBr, (CharArrayBuffer)dataOut);
    }

    @Override
    public boolean isVisible() {
        return this.zzaBs;
    }

    public Event freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzw.hashCode((Object[])new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public boolean equals(Object obj) {
        return EventEntity.zza(this, obj);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzw.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzw.equal((Object)event2.getName(), (Object)event.getName()) && zzw.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzw.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzw.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzw.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzw.equal((Object)event2.getValue(), (Object)event.getValue()) && zzw.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzw.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzw.zzx((Object)event).zzg("Id", (Object)event.getEventId()).zzg("Name", (Object)event.getName()).zzg("Description", (Object)event.getDescription()).zzg("IconImageUri", (Object)event.getIconImageUri()).zzg("IconImageUrl", (Object)event.getIconImageUrl()).zzg("Player", (Object)event.getPlayer()).zzg("Value", (Object)event.getValue()).zzg("FormattedValue", (Object)event.getFormattedValue()).zzg("isVisible", (Object)event.isVisible()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        EventEntityCreator.zza(this, out, flags);
    }
}

