/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.internal.zznx;
import java.lang.ref.WeakReference;

public class PopupManager {
    protected GamesClientImpl zzaDb;
    protected PopupLocationInfo zzaDc;

    public static PopupManager zza(GamesClientImpl gamesClientImpl, int n) {
        if (zznx.zzrO()) {
            return new PopupManagerHCMR1(gamesClientImpl, n);
        }
        return new PopupManager(gamesClientImpl, n);
    }

    private PopupManager(GamesClientImpl gamesClientImpl, int gravity) {
        this.zzaDb = gamesClientImpl;
        this.zzgn(gravity);
    }

    protected void zzgn(int n) {
        this.zzaDc = new PopupLocationInfo(n, (IBinder)new Binder());
    }

    public void setGravity(int gravity) {
        this.zzaDc.gravity = gravity;
    }

    public void zzp(View view) {
    }

    public void zzwA() {
        this.zzaDb.zza(this.zzaDc.zzaDd, this.zzaDc.zzwz());
    }

    public Bundle zzwB() {
        return this.zzaDc.zzwz();
    }

    public IBinder zzwC() {
        return this.zzaDc.zzaDd;
    }

    public PopupLocationInfo zzwD() {
        return this.zzaDc;
    }

    public static final class PopupLocationInfo {
        public IBinder zzaDd;
        public int gravity;
        public int zzaDe = -1;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        private PopupLocationInfo(int gravity, IBinder windowToken) {
            this.gravity = gravity;
            this.zzaDd = windowToken;
        }

        public Bundle zzwz() {
            Bundle bundle = new Bundle();
            bundle.putInt("popupLocationInfo.gravity", this.gravity);
            bundle.putInt("popupLocationInfo.displayId", this.zzaDe);
            bundle.putInt("popupLocationInfo.left", this.left);
            bundle.putInt("popupLocationInfo.top", this.top);
            bundle.putInt("popupLocationInfo.right", this.right);
            bundle.putInt("popupLocationInfo.bottom", this.bottom);
            return bundle;
        }
    }

    private static final class PopupManagerHCMR1
    extends PopupManager
    implements View.OnAttachStateChangeListener,
    ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<View> zzaDf;
        private boolean zzaBA = false;

        protected PopupManagerHCMR1(GamesClientImpl gamesClientImpl, int gravity) {
            super(gamesClientImpl, gravity);
        }

        @Override
        protected void zzgn(int n) {
            this.zzaDc = new PopupLocationInfo(n, null);
        }

        @Override
        public void zzp(View view) {
            Context context;
            View view2;
            this.zzaDb.zzwn();
            if (this.zzaDf != null) {
                view2 = (View)this.zzaDf.get();
                context = this.zzaDb.getContext();
                if (view2 == null && context instanceof Activity) {
                    view2 = ((Activity)context).getWindow().getDecorView();
                }
                if (view2 != null) {
                    view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewTreeObserver viewTreeObserver = view2.getViewTreeObserver();
                    if (zznx.zzrR()) {
                        viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            }
            this.zzaDf = null;
            view2 = this.zzaDb.getContext();
            if (view == null && view2 instanceof Activity) {
                context = (Activity)view2;
                view = context.findViewById(0x1020002);
                if (view == null) {
                    view = ((Activity)view2).getWindow().getDecorView();
                }
                GamesLog.zzA("PopupManager", "You have not specified a View to use as content view for popups. Falling back to the Activity content view. Note that this may not work as expected in multi-screen environments");
            }
            if (view != null) {
                this.zzq(view);
                this.zzaDf = new WeakReference<View>(view);
                view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                context = view.getViewTreeObserver();
                context.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                GamesLog.zzB("PopupManager", "No content view usable to display popups. Popups will not be displayed in response to this client's calls. Use setViewForPopups() to set your content view.");
            }
        }

        @Override
        public void zzwA() {
            if (this.zzaDc.zzaDd != null) {
                super.zzwA();
                return;
            }
            this.zzaBA = this.zzaDf != null;
        }

        public void onViewAttachedToWindow(View v) {
            this.zzq(v);
        }

        public void onViewDetachedFromWindow(View v) {
            this.zzaDb.zzwn();
            v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onGlobalLayout() {
            if (this.zzaDf == null) {
                return;
            }
            View view = (View)this.zzaDf.get();
            if (view == null) {
                return;
            }
            this.zzq(view);
        }

        private void zzq(View view) {
            Display display;
            int n = -1;
            if (zznx.zzrS()) {
                display = view.getDisplay();
                n = display != null ? display.getDisplayId() : -1;
            }
            display = view.getWindowToken();
            int[] nArray = new int[2];
            view.getLocationInWindow(nArray);
            int n2 = view.getWidth();
            int n3 = view.getHeight();
            this.zzaDc.zzaDe = n;
            this.zzaDc.zzaDd = display;
            this.zzaDc.left = nArray[0];
            this.zzaDc.top = nArray[1];
            this.zzaDc.right = nArray[0] + n2;
            this.zzaDc.bottom = nArray[1] + n3;
            if (this.zzaBA) {
                this.zzwA();
                this.zzaBA = false;
            }
        }
    }
}

