/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.api;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Games;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzmn;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class RequestsImpl
implements Requests {
    @Override
    public void registerRequestListener(GoogleApiClient apiClient, OnRequestReceivedListener listener) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            zzmn zzmn2 = apiClient.zzq((Object)listener);
            gamesClientImpl.zzd((zzmn<OnRequestReceivedListener>)zzmn2);
        }
    }

    @Override
    public void unregisterRequestListener(GoogleApiClient apiClient) {
        GamesClientImpl gamesClientImpl = Games.zzb(apiClient, false);
        if (gamesClientImpl != null) {
            gamesClientImpl.zzwc();
        }
    }

    @Override
    public Intent getInboxIntent(GoogleApiClient apiClient) {
        return Games.zzf(apiClient).zzwi();
    }

    @Override
    public Intent getSendIntent(GoogleApiClient apiClient, int type, byte[] payload, int requestLifetimeDays, Bitmap icon, String description) {
        return Games.zzf(apiClient).zza(type, payload, requestLifetimeDays, icon, description);
    }

    @Override
    public int getMaxPayloadSize(GoogleApiClient apiClient) {
        return Games.zzf(apiClient).zzwj();
    }

    @Override
    public int getMaxLifetimeDays(GoogleApiClient apiClient) {
        return Games.zzf(apiClient).zzwk();
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> acceptRequest(GoogleApiClient apiClient, String requestId) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(requestId);
        return this.acceptRequests(apiClient, arrayList);
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> acceptRequests(GoogleApiClient apiClient, List<String> requestIds) {
        final String[] stringArray = requestIds == null ? null : requestIds.toArray(new String[requestIds.size()]);
        return apiClient.zzb((zzlx.zza)new UpdateRequestsImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzb((zzlx.zzb<Requests.UpdateRequestsResult>)this, stringArray);
            }
        });
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> dismissRequest(GoogleApiClient apiClient, String requestId) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(requestId);
        return this.dismissRequests(apiClient, arrayList);
    }

    @Override
    public PendingResult<Requests.UpdateRequestsResult> dismissRequests(GoogleApiClient apiClient, List<String> requestIds) {
        final String[] stringArray = requestIds == null ? null : requestIds.toArray(new String[requestIds.size()]);
        return apiClient.zzb((zzlx.zza)new UpdateRequestsImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zzc((zzlx.zzb<Requests.UpdateRequestsResult>)this, stringArray);
            }
        });
    }

    @Override
    public PendingResult<Requests.LoadRequestsResult> loadRequests(GoogleApiClient apiClient, final int requestDirection, final int types, final int sortOrder) {
        return apiClient.zza((zzlx.zza)new LoadRequestsImpl(apiClient){

            protected void zza(GamesClientImpl gamesClientImpl) throws RemoteException {
                gamesClientImpl.zza((zzlx.zzb<Requests.LoadRequestsResult>)this, requestDirection, types, sortOrder);
            }
        });
    }

    @Override
    public ArrayList<GameRequest> getGameRequestsFromInboxResponse(Intent response) {
        if (response == null) {
            return new ArrayList<GameRequest>();
        }
        return this.getGameRequestsFromBundle(response.getExtras());
    }

    @Override
    public ArrayList<GameRequest> getGameRequestsFromBundle(Bundle extras) {
        if (extras == null || !extras.containsKey("requests")) {
            return new ArrayList<GameRequest>();
        }
        ArrayList arrayList = (ArrayList)extras.get("requests");
        ArrayList<GameRequest> arrayList2 = new ArrayList<GameRequest>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList2.add((GameRequest)arrayList.get(i));
        }
        return arrayList2;
    }

    private static abstract class LoadRequestSummariesImpl
    extends Games.BaseGamesApiMethodImpl<Requests.LoadRequestSummariesResult> {
        public Requests.LoadRequestSummariesResult zzay(final Status status) {
            return new Requests.LoadRequestSummariesResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzay(status);
        }
    }

    private static abstract class SendRequestImpl
    extends Games.BaseGamesApiMethodImpl<Requests.SendRequestResult> {
        public Requests.SendRequestResult zzaA(final Status status) {
            return new Requests.SendRequestResult(){

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaA(status);
        }
    }

    private static abstract class UpdateRequestsImpl
    extends Games.BaseGamesApiMethodImpl<Requests.UpdateRequestsResult> {
        private UpdateRequestsImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Requests.UpdateRequestsResult zzaB(final Status status) {
            return new Requests.UpdateRequestsResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public int getRequestOutcome(String requestId) {
                    throw new IllegalArgumentException("Unknown request ID " + requestId);
                }

                @Override
                public Set<String> getRequestIds() {
                    return null;
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaB(status);
        }
    }

    private static abstract class LoadRequestsImpl
    extends Games.BaseGamesApiMethodImpl<Requests.LoadRequestsResult> {
        private LoadRequestsImpl(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Requests.LoadRequestsResult zzaz(final Status status) {
            return new Requests.LoadRequestsResult(){

                public Status getStatus() {
                    return status;
                }

                public void release() {
                }

                @Override
                public GameRequestBuffer getRequests(int type) {
                    int n = status.getStatusCode();
                    return new GameRequestBuffer(DataHolder.zzbJ((int)n));
                }
            };
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzaz(status);
        }
    }
}

