/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.request;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.internal.constants.RequestUpdateResultOutcome;
import java.util.HashMap;
import java.util.Set;

public final class RequestUpdateOutcomes {
    private static final String[] zzaGn = new String[]{"requestId", "outcome"};
    private final int zzabx;
    private final HashMap<String, Integer> zzaGo;

    private RequestUpdateOutcomes(int statusCode, HashMap<String, Integer> outcomeMap) {
        this.zzabx = statusCode;
        this.zzaGo = outcomeMap;
    }

    public int getRequestOutcome(String requestId) {
        zzx.zzb((boolean)this.zzaGo.containsKey(requestId), (Object)("Request " + requestId + " was not part of the update operation!"));
        return this.zzaGo.get(requestId);
    }

    public Set<String> getRequestIds() {
        return this.zzaGo.keySet();
    }

    public static RequestUpdateOutcomes zzab(DataHolder dataHolder) {
        Builder builder = new Builder();
        builder.zzgy(dataHolder.getStatusCode());
        int n = dataHolder.getCount();
        for (int i = 0; i < n; ++i) {
            int n2 = dataHolder.zzbI(i);
            builder.zzx(dataHolder.zzd("requestId", i, n2), dataHolder.zzc("outcome", i, n2));
        }
        return builder.zzxa();
    }

    public static final class Builder {
        private HashMap<String, Integer> zzaGo = new HashMap();
        private int zzabx = 0;

        public Builder zzx(String string, int n) {
            if (RequestUpdateResultOutcome.isValid(n)) {
                this.zzaGo.put(string, n);
            }
            return this;
        }

        public Builder zzgy(int n) {
            this.zzabx = n;
            return this;
        }

        public RequestUpdateOutcomes zzxa() {
            return new RequestUpdateOutcomes(this.zzabx, this.zzaGo);
        }
    }
}

