/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantEntity;
import com.google.android.gms.internal.zznn;
import java.util.ArrayList;

public final class LeaderboardEntity
implements Leaderboard {
    private final String zzaGp;
    private final String zzVu;
    private final Uri zzazC;
    private final int zzaGq;
    private final ArrayList<LeaderboardVariantEntity> zzaGr;
    private final Game zzaGs;
    private final String zzazN;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.zzaGp = leaderboard.getLeaderboardId();
        this.zzVu = leaderboard.getDisplayName();
        this.zzazC = leaderboard.getIconImageUri();
        this.zzazN = leaderboard.getIconImageUrl();
        this.zzaGq = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.zzaGs = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.zzaGr = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaGr.add((LeaderboardVariantEntity)arrayList.get(i).freeze());
        }
    }

    @Override
    public String getLeaderboardId() {
        return this.zzaGp;
    }

    @Override
    public String getDisplayName() {
        return this.zzVu;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.zzVu, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzazC;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzazN;
    }

    @Override
    public int getScoreOrder() {
        return this.zzaGq;
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.zzaGr);
    }

    @Override
    public Game getGame() {
        return this.zzaGs;
    }

    public Leaderboard zzxb() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return zzw.hashCode((Object[])new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public boolean equals(Object obj) {
        return LeaderboardEntity.zza(this, obj);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzw.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzw.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzw.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzw.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzw.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzw.zzx((Object)leaderboard).zzg("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zzg("DisplayName", (Object)leaderboard.getDisplayName()).zzg("IconImageUri", (Object)leaderboard.getIconImageUri()).zzg("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zzg("ScoreOrder", (Object)leaderboard.getScoreOrder()).zzg("Variants", leaderboard.getVariants()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzxb();
    }
}

