/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.internal.zznn;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzaCu;
    private final String zzVu;
    private final Uri zzazC;
    private final Uri zzazD;
    private final int zzAk;
    private final String zzaBt;
    private final boolean zzaHc;
    private final PlayerEntity zzaAL;
    private final int zzYv;
    private final ParticipantResult zzaHd;
    private final String zzazN;
    private final String zzazO;

    public ParticipantEntity(Participant participant) {
        this.mVersionCode = 3;
        this.zzaCu = participant.getParticipantId();
        this.zzVu = participant.getDisplayName();
        this.zzazC = participant.getIconImageUri();
        this.zzazD = participant.getHiResImageUri();
        this.zzAk = participant.getStatus();
        this.zzaBt = participant.zzvN();
        this.zzaHc = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzaAL = player == null ? null : new PlayerEntity(player);
        this.zzYv = participant.getCapabilities();
        this.zzaHd = participant.getResult();
        this.zzazN = participant.getIconImageUrl();
        this.zzazO = participant.getHiResImageUrl();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result, String iconImageUrl, String hiResImageUrl) {
        this.mVersionCode = versionCode;
        this.zzaCu = participantId;
        this.zzVu = displayName;
        this.zzazC = iconImageUri;
        this.zzazD = hiResImageUri;
        this.zzAk = status;
        this.zzaBt = clientAddress;
        this.zzaHc = connectedToRoom;
        this.zzaAL = player;
        this.zzYv = capabilities;
        this.zzaHd = result;
        this.zzazN = iconImageUrl;
        this.zzazO = hiResImageUrl;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getStatus() {
        return this.zzAk;
    }

    @Override
    public String zzvN() {
        return this.zzaBt;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.zzaHc;
    }

    @Override
    public String getDisplayName() {
        if (this.zzaAL == null) {
            return this.zzVu;
        }
        return this.zzaAL.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.zzaAL == null) {
            zznn.zzb((String)this.zzVu, (CharArrayBuffer)dataOut);
            return;
        }
        this.zzaAL.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.zzaAL == null) {
            return this.zzazC;
        }
        return this.zzaAL.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.zzaAL == null) {
            return this.zzazN;
        }
        return this.zzaAL.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.zzaAL == null) {
            return this.zzazD;
        }
        return this.zzaAL.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.zzaAL == null) {
            return this.zzazO;
        }
        return this.zzaAL.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.zzaCu;
    }

    @Override
    public Player getPlayer() {
        return this.zzaAL;
    }

    @Override
    public ParticipantResult getResult() {
        return this.zzaHd;
    }

    @Override
    public int getCapabilities() {
        return this.zzYv;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return zzw.hashCode((Object[])new Object[]{participant.getPlayer(), participant.getStatus(), participant.zzvN(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId()});
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.zza(this, obj);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzw.equal((Object)participant2.getPlayer(), (Object)participant.getPlayer()) && zzw.equal((Object)participant2.getStatus(), (Object)participant.getStatus()) && zzw.equal((Object)participant2.zzvN(), (Object)participant.zzvN()) && zzw.equal((Object)participant2.isConnectedToRoom(), (Object)participant.isConnectedToRoom()) && zzw.equal((Object)participant2.getDisplayName(), (Object)participant.getDisplayName()) && zzw.equal((Object)participant2.getIconImageUri(), (Object)participant.getIconImageUri()) && zzw.equal((Object)participant2.getHiResImageUri(), (Object)participant.getHiResImageUri()) && zzw.equal((Object)participant2.getCapabilities(), (Object)participant.getCapabilities()) && zzw.equal((Object)participant2.getResult(), (Object)participant.getResult()) && zzw.equal((Object)participant2.getParticipantId(), (Object)participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzw.zzx((Object)participant).zzg("ParticipantId", (Object)participant.getParticipantId()).zzg("Player", (Object)participant.getPlayer()).zzg("Status", (Object)participant.getStatus()).zzg("ClientAddress", (Object)participant.zzvN()).zzg("ConnectedToRoom", (Object)participant.isConnectedToRoom()).zzg("DisplayName", (Object)participant.getDisplayName()).zzg("IconImage", (Object)participant.getIconImageUri()).zzg("IconImageUrl", (Object)participant.getIconImageUrl()).zzg("HiResImage", (Object)participant.getHiResImageUri()).zzg("HiResImageUrl", (Object)participant.getHiResImageUrl()).zzg("Capabilities", (Object)participant.getCapabilities()).zzg("Result", (Object)participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzqk()) {
            ParticipantEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzaCu);
            dest.writeString(this.zzVu);
            dest.writeString(this.zzazC == null ? null : this.zzazC.toString());
            dest.writeString(this.zzazD == null ? null : this.zzazD.toString());
            dest.writeInt(this.zzAk);
            dest.writeString(this.zzaBt);
            dest.writeInt(this.zzaHc ? 1 : 0);
            dest.writeInt(this.zzaAL == null ? 0 : 1);
            if (this.zzaAL != null) {
                this.zzaAL.writeToParcel(dest, flags);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity zzek(Parcel parcel) {
            boolean bl = ParticipantEntity.zzd(ParticipantEntity.zzqj());
            if (bl || ParticipantEntity.zzcz((String)ParticipantEntity.class.getCanonicalName())) {
                return super.zzek(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            int n2 = 7;
            ParticipantResult participantResult = null;
            String string6 = null;
            String string7 = null;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string, string2, uri, uri2, n, string5, bl2, playerEntity, n2, participantResult, string6, string7);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzek(x0);
        }
    }
}

