/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomConfigImpl;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class RoomConfig {
    protected RoomConfig() {
    }

    public abstract RoomUpdateListener getRoomUpdateListener();

    public abstract String getInvitationId();

    public abstract RoomStatusUpdateListener getRoomStatusUpdateListener();

    public abstract RealTimeMessageReceivedListener getMessageReceivedListener();

    public abstract int getVariant();

    public abstract String[] getInvitedPlayerIds();

    public abstract Bundle getAutoMatchCriteria();

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        final RoomUpdateListener zzaHk;
        RoomStatusUpdateListener zzaHl;
        RealTimeMessageReceivedListener zzaHm;
        String zzaHn = null;
        int zzaGZ = -1;
        ArrayList<String> zzaHo = new ArrayList();
        Bundle zzaHp;

        private Builder(RoomUpdateListener updateListener) {
            this.zzaHk = (RoomUpdateListener)zzx.zzb((Object)updateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            zzx.zzy((Object)invitationId);
            this.zzaHn = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.zzaHl = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.zzaHm = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            zzx.zzy((Object)playerIds);
            this.zzaHo.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            zzx.zzy(playerIds);
            this.zzaHo.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            zzx.zzb((variant == -1 || variant > 0 ? 1 : 0) != 0, (Object)"Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.zzaGZ = variant;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.zzaHp = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfigImpl(this);
        }
    }
}

