/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import com.google.android.gms.internal.zznn;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
implements SafeParcelable,
Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new QuestEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaGU;
    private final String zzaHM;
    private final long zzaHN;
    private final Uri zzaHO;
    private final String zzaHP;
    private final String zzavc;
    private final long zzaHQ;
    private final long zzaAO;
    private final Uri zzaHR;
    private final String zzaHS;
    private final String mName;
    private final long zzaHT;
    private final long zzaHU;
    private final int mState;
    private final int zzZU;
    private final ArrayList<MilestoneEntity> zzaHV;

    public QuestEntity(Quest quest) {
        this.mVersionCode = 2;
        this.zzaGU = new GameEntity(quest.getGame());
        this.zzaHM = quest.getQuestId();
        this.zzaHN = quest.getAcceptedTimestamp();
        this.zzavc = quest.getDescription();
        this.zzaHO = quest.getBannerImageUri();
        this.zzaHP = quest.getBannerImageUrl();
        this.zzaHQ = quest.getEndTimestamp();
        this.zzaHR = quest.getIconImageUri();
        this.zzaHS = quest.getIconImageUrl();
        this.zzaAO = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzaHT = quest.zzxl();
        this.zzaHU = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzZU = quest.getType();
        List<Milestone> list = quest.zzxk();
        int n = list.size();
        this.zzaHV = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaHV.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(int versionCode, GameEntity game, String questId, long acceptedTimestamp, Uri bannerImageUri, String bannerImageUrl, String description, long endTimestamp, long lastUpdatedTimestamp, Uri iconImageUri, String iconImageUrl, String name, long notifyTimestamp, long startTimestamp, int state, int type, ArrayList<MilestoneEntity> milestones) {
        this.mVersionCode = versionCode;
        this.zzaGU = game;
        this.zzaHM = questId;
        this.zzaHN = acceptedTimestamp;
        this.zzaHO = bannerImageUri;
        this.zzaHP = bannerImageUrl;
        this.zzavc = description;
        this.zzaHQ = endTimestamp;
        this.zzaAO = lastUpdatedTimestamp;
        this.zzaHR = iconImageUri;
        this.zzaHS = iconImageUrl;
        this.mName = name;
        this.zzaHT = notifyTimestamp;
        this.zzaHU = startTimestamp;
        this.mState = state;
        this.zzZU = type;
        this.zzaHV = milestones;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getQuestId() {
        return this.zzaHM;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzavc;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zznn.zzb((String)this.zzavc, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaHR;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaHS;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.zzaHO;
    }

    @Override
    public String getBannerImageUrl() {
        return this.zzaHP;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzxk().get(0);
    }

    @Override
    public List<Milestone> zzxk() {
        return new ArrayList<Milestone>(this.zzaHV);
    }

    @Override
    public Game getGame() {
        return this.zzaGU;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.zzZU;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.zzaHN;
    }

    @Override
    public long getEndTimestamp() {
        return this.zzaHQ;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzaAO;
    }

    @Override
    public long zzxl() {
        return this.zzaHT;
    }

    @Override
    public long getStartTimestamp() {
        return this.zzaHU;
    }

    @Override
    public boolean isEndingSoon() {
        return this.zzaHT <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return zzw.hashCode((Object[])new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzxk(), quest.getName(), quest.zzxl(), quest.getStartTimestamp(), quest.getState()});
    }

    public boolean equals(Object obj) {
        return QuestEntity.zza(this, obj);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzw.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzw.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzw.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzw.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzw.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzw.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzw.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzw.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzw.equal(quest2.zzxk(), quest.zzxk()) && zzw.equal((Object)quest2.getName(), (Object)quest.getName()) && zzw.equal((Object)quest2.zzxl(), (Object)quest.zzxl()) && zzw.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzw.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzw.zzx((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzxk()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzxl()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        QuestEntityCreator.zza(this, out, flags);
    }
}

