/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;

public abstract class SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChangeEntity();

    protected SnapshotMetadataChange() {
    }

    public abstract String getDescription();

    public abstract Long getPlayedTimeMillis();

    public abstract BitmapTeleporter zzxn();

    public abstract Bitmap getCoverImage();

    public abstract Long getProgressValue();

    public static final class Builder {
        private String zzavc;
        private Long zzaId;
        private Long zzaIe;
        private BitmapTeleporter zzaIf;
        private Uri zzaIg;

        public Builder setDescription(String description) {
            this.zzavc = description;
            return this;
        }

        public Builder setPlayedTimeMillis(long playedTimeMillis) {
            this.zzaId = playedTimeMillis;
            return this;
        }

        public Builder setProgressValue(long progressValue) {
            this.zzaIe = progressValue;
            return this;
        }

        public Builder setCoverImage(Bitmap coverImage) {
            this.zzaIf = new BitmapTeleporter(coverImage);
            this.zzaIg = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata metadata) {
            this.zzavc = metadata.getDescription();
            this.zzaId = metadata.getPlayedTime();
            this.zzaIe = metadata.getProgressValue();
            if (this.zzaId == -1L) {
                this.zzaId = null;
            }
            this.zzaIg = metadata.getCoverImageUri();
            if (this.zzaIg != null) {
                this.zzaIf = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChangeEntity(this.zzavc, this.zzaId, this.zzaIf, this.zzaIg, this.zzaIe);
        }
    }
}

