/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.stats;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsEntityCreator;

public class PlayerStatsEntity
implements SafeParcelable,
PlayerStats {
    public static final Parcelable.Creator<PlayerStatsEntity> CREATOR = new PlayerStatsEntityCreator();
    private final int mVersionCode;
    private final float zzaIt;
    private final float zzaIu;
    private final int zzaIv;
    private final int zzaIw;
    private final int zzaIx;
    private final float zzaIy;
    private final float zzaIz;
    private final Bundle zzaIA;

    public PlayerStatsEntity(PlayerStats playerStats) {
        this.mVersionCode = 2;
        this.zzaIt = playerStats.getAverageSessionLength();
        this.zzaIu = playerStats.getChurnProbability();
        this.zzaIv = playerStats.getDaysSinceLastPlayed();
        this.zzaIw = playerStats.getNumberOfPurchases();
        this.zzaIx = playerStats.getNumberOfSessions();
        this.zzaIy = playerStats.getSessionPercentile();
        this.zzaIz = playerStats.getSpendPercentile();
        this.zzaIA = playerStats.zzxo();
    }

    PlayerStatsEntity(int versionCode, float averageSessionLength, float churnProbability, int daysSinceLastPlayed, int numberOfPurchases, int numberOfSessions, float sessionPercentile, float spendPercentile, Bundle rawValues) {
        this.mVersionCode = versionCode;
        this.zzaIt = averageSessionLength;
        this.zzaIu = churnProbability;
        this.zzaIv = daysSinceLastPlayed;
        this.zzaIw = numberOfPurchases;
        this.zzaIx = numberOfSessions;
        this.zzaIy = sessionPercentile;
        this.zzaIz = spendPercentile;
        this.zzaIA = rawValues;
    }

    @Override
    public float getAverageSessionLength() {
        return this.zzaIt;
    }

    @Override
    public float getChurnProbability() {
        return this.zzaIu;
    }

    @Override
    public int getDaysSinceLastPlayed() {
        return this.zzaIv;
    }

    @Override
    public int getNumberOfPurchases() {
        return this.zzaIw;
    }

    @Override
    public int getNumberOfSessions() {
        return this.zzaIx;
    }

    @Override
    public float getSessionPercentile() {
        return this.zzaIy;
    }

    @Override
    public float getSpendPercentile() {
        return this.zzaIz;
    }

    @Override
    public Bundle zzxo() {
        return this.zzaIA;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public PlayerStats zzxp() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerStatsEntity.zza(this);
    }

    static int zza(PlayerStats playerStats) {
        return zzw.hashCode((Object[])new Object[]{Float.valueOf(playerStats.getAverageSessionLength()), Float.valueOf(playerStats.getChurnProbability()), playerStats.getDaysSinceLastPlayed(), playerStats.getNumberOfPurchases(), playerStats.getNumberOfSessions(), Float.valueOf(playerStats.getSessionPercentile()), Float.valueOf(playerStats.getSpendPercentile())});
    }

    public boolean equals(Object obj) {
        return PlayerStatsEntity.zza(this, obj);
    }

    static boolean zza(PlayerStats playerStats, Object object) {
        if (!(object instanceof PlayerStats)) {
            return false;
        }
        if (playerStats == object) {
            return true;
        }
        PlayerStats playerStats2 = (PlayerStats)object;
        return zzw.equal((Object)Float.valueOf(playerStats2.getAverageSessionLength()), (Object)Float.valueOf(playerStats.getAverageSessionLength())) && zzw.equal((Object)Float.valueOf(playerStats2.getChurnProbability()), (Object)Float.valueOf(playerStats.getChurnProbability())) && zzw.equal((Object)playerStats2.getDaysSinceLastPlayed(), (Object)playerStats.getDaysSinceLastPlayed()) && zzw.equal((Object)playerStats2.getNumberOfPurchases(), (Object)playerStats.getNumberOfPurchases()) && zzw.equal((Object)playerStats2.getNumberOfSessions(), (Object)playerStats.getNumberOfSessions()) && zzw.equal((Object)Float.valueOf(playerStats2.getSessionPercentile()), (Object)Float.valueOf(playerStats.getSessionPercentile())) && zzw.equal((Object)Float.valueOf(playerStats2.getSpendPercentile()), (Object)Float.valueOf(playerStats.getSpendPercentile()));
    }

    public String toString() {
        return PlayerStatsEntity.zzb(this);
    }

    static String zzb(PlayerStats playerStats) {
        return zzw.zzx((Object)playerStats).zzg("AverageSessionLength", (Object)Float.valueOf(playerStats.getAverageSessionLength())).zzg("ChurnProbability", (Object)Float.valueOf(playerStats.getChurnProbability())).zzg("DaysSinceLastPlayed", (Object)playerStats.getDaysSinceLastPlayed()).zzg("NumberOfPurchases", (Object)playerStats.getNumberOfPurchases()).zzg("NumberOfSessions", (Object)playerStats.getNumberOfSessions()).zzg("SessionPercentile", (Object)Float.valueOf(playerStats.getSessionPercentile())).zzg("SpendPercentile", (Object)Float.valueOf(playerStats.getSpendPercentile())).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerStatsEntityCreator.zza(this, out, flags);
    }

    public /* synthetic */ Object freeze() {
        return this.zzxp();
    }
}

