/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.video.Video;
import com.google.android.gms.games.video.VideoEntityCreator;

public final class VideoEntity
implements SafeParcelable,
Video {
    public static final Parcelable.Creator<VideoEntity> CREATOR = new VideoEntityCreator();
    private final int mVersionCode;
    private final int zzaiv;
    private final String zzaIF;
    private final long zzaIG;
    private final long zzBv;
    private final String zzSp;

    public VideoEntity(Video video) {
        this.mVersionCode = 1;
        this.zzaiv = video.getDuration();
        this.zzaIF = video.zzxq();
        this.zzaIG = video.getFileSize();
        this.zzBv = video.getStartTime();
        this.zzSp = video.getPackageName();
        zzb.zzu((Object)this.zzaIF);
        zzb.zzu((Object)this.zzSp);
    }

    VideoEntity(int versionCode, int duration, String filePath, long fileSize, long startTime, String packageName) {
        this.mVersionCode = versionCode;
        this.zzaiv = duration;
        this.zzaIF = filePath;
        this.zzaIG = fileSize;
        this.zzBv = startTime;
        this.zzSp = packageName;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getDuration() {
        return this.zzaiv;
    }

    @Override
    public String zzxq() {
        return this.zzaIF;
    }

    @Override
    public long getFileSize() {
        return this.zzaIG;
    }

    @Override
    public long getStartTime() {
        return this.zzBv;
    }

    @Override
    public String getPackageName() {
        return this.zzSp;
    }

    public Video zzxu() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return VideoEntity.zza(this);
    }

    static int zza(Video video) {
        return zzw.hashCode((Object[])new Object[]{video.getDuration(), video.zzxq(), video.getFileSize(), video.getStartTime(), video.getPackageName()});
    }

    public boolean equals(Object obj) {
        return VideoEntity.zza(this, obj);
    }

    static boolean zza(Video video, Object object) {
        if (!(object instanceof Video)) {
            return false;
        }
        if (video == object) {
            return true;
        }
        Video video2 = (Video)object;
        return zzw.equal((Object)video2.getDuration(), (Object)video.getDuration()) && zzw.equal((Object)video2.zzxq(), (Object)video.zzxq()) && zzw.equal((Object)video2.getFileSize(), (Object)video.getFileSize()) && zzw.equal((Object)video2.getStartTime(), (Object)video.getStartTime()) && zzw.equal((Object)video2.getPackageName(), (Object)video.getPackageName());
    }

    public String toString() {
        return VideoEntity.zzb(this);
    }

    static String zzb(Video video) {
        zzw.zza zza2 = zzw.zzx((Object)video).zzg("Duration", (Object)video.getDuration()).zzg("File path", (Object)video.zzxq()).zzg("File size", (Object)video.getFileSize()).zzg("Start time", (Object)video.getStartTime()).zzg("Package name", (Object)video.getPackageName());
        return zza2.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        VideoEntityCreator.zza(this, dest, flags);
    }

    public /* synthetic */ Object freeze() {
        return this.zzxu();
    }
}

