/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfoCreator;

public final class PlayerLevelInfo
implements SafeParcelable {
    public static final Parcelable.Creator<PlayerLevelInfo> CREATOR = new PlayerLevelInfoCreator();
    private final int mVersionCode;
    private final long zzaDd;
    private final long zzaDe;
    private final PlayerLevel zzaDf;
    private final PlayerLevel zzaDg;

    public PlayerLevelInfo(long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        this(1, currentXpTotal, lastLevelUpTimestamp, currentLevel, nextLevel);
    }

    PlayerLevelInfo(int versionCode, long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        zzx.zzab((currentXpTotal != -1L ? 1 : 0) != 0);
        zzx.zzz((Object)currentLevel);
        zzx.zzz((Object)nextLevel);
        this.mVersionCode = versionCode;
        this.zzaDd = currentXpTotal;
        this.zzaDe = lastLevelUpTimestamp;
        this.zzaDf = currentLevel;
        this.zzaDg = nextLevel;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public long getCurrentXpTotal() {
        return this.zzaDd;
    }

    public long getLastLevelUpTimestamp() {
        return this.zzaDe;
    }

    public PlayerLevel getCurrentLevel() {
        return this.zzaDf;
    }

    public PlayerLevel getNextLevel() {
        return this.zzaDg;
    }

    public boolean isMaxLevel() {
        return this.zzaDf.equals(this.zzaDg);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevelInfo)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PlayerLevelInfo playerLevelInfo = (PlayerLevelInfo)obj;
        return zzw.equal((Object)this.zzaDd, (Object)playerLevelInfo.zzaDd) && zzw.equal((Object)this.zzaDe, (Object)playerLevelInfo.zzaDe) && zzw.equal((Object)this.zzaDf, (Object)playerLevelInfo.zzaDf) && zzw.equal((Object)this.zzaDg, (Object)playerLevelInfo.zzaDg);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzaDd, this.zzaDe, this.zzaDf, this.zzaDg});
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelInfoCreator.zza(this, out, flags);
    }
}

