/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardVariant;
import com.google.android.gms.games.leaderboard.LeaderboardVariantEntity;
import com.google.android.gms.internal.zzms;
import java.util.ArrayList;

public final class LeaderboardEntity
implements Leaderboard {
    private final String zzaIZ;
    private final String zzWQ;
    private final Uri zzaCd;
    private final int zzaJa;
    private final ArrayList<LeaderboardVariantEntity> zzaJb;
    private final Game zzaJc;
    private final String zzaCo;

    public LeaderboardEntity(Leaderboard leaderboard) {
        this.zzaIZ = leaderboard.getLeaderboardId();
        this.zzWQ = leaderboard.getDisplayName();
        this.zzaCd = leaderboard.getIconImageUri();
        this.zzaCo = leaderboard.getIconImageUrl();
        this.zzaJa = leaderboard.getScoreOrder();
        Game game = leaderboard.getGame();
        this.zzaJc = game == null ? null : new GameEntity(game);
        ArrayList<LeaderboardVariant> arrayList = leaderboard.getVariants();
        int n = arrayList.size();
        this.zzaJb = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaJb.add((LeaderboardVariantEntity)arrayList.get(i).freeze());
        }
    }

    @Override
    public String getLeaderboardId() {
        return this.zzaIZ;
    }

    @Override
    public String getDisplayName() {
        return this.zzWQ;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        zzms.zzb((String)this.zzWQ, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaCd;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaCo;
    }

    @Override
    public int getScoreOrder() {
        return this.zzaJa;
    }

    @Override
    public ArrayList<LeaderboardVariant> getVariants() {
        return new ArrayList<LeaderboardVariant>(this.zzaJb);
    }

    @Override
    public Game getGame() {
        return this.zzaJc;
    }

    public Leaderboard zzxI() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardEntity.zza(this);
    }

    static int zza(Leaderboard leaderboard) {
        return zzw.hashCode((Object[])new Object[]{leaderboard.getLeaderboardId(), leaderboard.getDisplayName(), leaderboard.getIconImageUri(), leaderboard.getScoreOrder(), leaderboard.getVariants()});
    }

    public boolean equals(Object obj) {
        return LeaderboardEntity.zza(this, obj);
    }

    static boolean zza(Leaderboard leaderboard, Object object) {
        if (!(object instanceof Leaderboard)) {
            return false;
        }
        if (leaderboard == object) {
            return true;
        }
        Leaderboard leaderboard2 = (Leaderboard)object;
        return zzw.equal((Object)leaderboard2.getLeaderboardId(), (Object)leaderboard.getLeaderboardId()) && zzw.equal((Object)leaderboard2.getDisplayName(), (Object)leaderboard.getDisplayName()) && zzw.equal((Object)leaderboard2.getIconImageUri(), (Object)leaderboard.getIconImageUri()) && zzw.equal((Object)leaderboard2.getScoreOrder(), (Object)leaderboard.getScoreOrder()) && zzw.equal(leaderboard2.getVariants(), leaderboard.getVariants());
    }

    public String toString() {
        return LeaderboardEntity.zzb(this);
    }

    static String zzb(Leaderboard leaderboard) {
        return zzw.zzy((Object)leaderboard).zzg("LeaderboardId", (Object)leaderboard.getLeaderboardId()).zzg("DisplayName", (Object)leaderboard.getDisplayName()).zzg("IconImageUri", (Object)leaderboard.getIconImageUri()).zzg("IconImageUrl", (Object)leaderboard.getIconImageUrl()).zzg("ScoreOrder", (Object)leaderboard.getScoreOrder()).zzg("Variants", leaderboard.getVariants()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzxI();
    }
}

