/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
implements SafeParcelable,
GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new GameRequestEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaJE;
    private final PlayerEntity zzaKG;
    private final byte[] zzaKm;
    private final String zzEY;
    private final ArrayList<PlayerEntity> zzaKH;
    private final int zzabB;
    private final long zzaJF;
    private final long zzaKI;
    private final Bundle zzaKJ;
    private final int zzBc;

    public GameRequestEntity(GameRequest request) {
        this.mVersionCode = 2;
        this.zzaJE = new GameEntity(request.getGame());
        this.zzaKG = new PlayerEntity(request.getSender());
        this.zzEY = request.getRequestId();
        this.zzabB = request.getType();
        this.zzaJF = request.getCreationTimestamp();
        this.zzaKI = request.getExpirationTimestamp();
        this.zzBc = request.getStatus();
        byte[] byArray = request.getData();
        if (byArray == null) {
            this.zzaKm = null;
        } else {
            this.zzaKm = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzaKm, 0, byArray.length);
        }
        List<Player> list = request.getRecipients();
        int n = list.size();
        this.zzaKH = new ArrayList(n);
        this.zzaKJ = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string = player.getPlayerId();
            this.zzaKH.add((PlayerEntity)player);
            this.zzaKJ.putInt(string, request.getRecipientStatus(string));
        }
    }

    GameRequestEntity(int versionCode, GameEntity game, PlayerEntity sender, byte[] data, String requestId, ArrayList<PlayerEntity> recipients, int type, long creationTimestamp, long expirationTimestamp, Bundle recipientStatuses, int status) {
        this.mVersionCode = versionCode;
        this.zzaJE = game;
        this.zzaKG = sender;
        this.zzaKm = data;
        this.zzEY = requestId;
        this.zzaKH = recipients;
        this.zzabB = type;
        this.zzaJF = creationTimestamp;
        this.zzaKI = expirationTimestamp;
        this.zzaKJ = recipientStatuses;
        this.zzBc = status;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRequestId() {
        return this.zzEY;
    }

    @Override
    public Game getGame() {
        return this.zzaJE;
    }

    @Override
    public Player getSender() {
        return this.zzaKG;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzaKH);
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.zzaKm;
    }

    @Override
    public int getType() {
        return this.zzabB;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaJF;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.zzaKI;
    }

    @Override
    public int getRecipientStatus(String playerId) {
        return this.zzaKJ.getInt(playerId, 0);
    }

    @Override
    public int getStatus() {
        return this.zzBc;
    }

    public Bundle zzxT() {
        return this.zzaKJ;
    }

    public GameRequest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return zzw.hashCode((Object[])new Object[]{gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp()});
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.zza(this, obj);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzw.equal((Object)gameRequest2.getGame(), (Object)gameRequest.getGame()) && zzw.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzw.equal((Object)gameRequest2.getRequestId(), (Object)gameRequest.getRequestId()) && zzw.equal((Object)gameRequest2.getSender(), (Object)gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzw.equal((Object)gameRequest2.getType(), (Object)gameRequest.getType()) && zzw.equal((Object)gameRequest2.getCreationTimestamp(), (Object)gameRequest.getCreationTimestamp()) && zzw.equal((Object)gameRequest2.getExpirationTimestamp(), (Object)gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzw.zzy((Object)gameRequest).zzg("Game", (Object)gameRequest.getGame()).zzg("Sender", (Object)gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", (Object)gameRequest.getData()).zzg("RequestId", (Object)gameRequest.getRequestId()).zzg("Type", (Object)gameRequest.getType()).zzg("CreationTimestamp", (Object)gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", (Object)gameRequest.getExpirationTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntityCreator.zza(this, dest, flags);
    }
}

