/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;

public abstract class SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChangeEntity();

    protected SnapshotMetadataChange() {
    }

    public abstract String getDescription();

    public abstract Long getPlayedTimeMillis();

    public abstract BitmapTeleporter zzxU();

    public abstract Bitmap getCoverImage();

    public abstract Long getProgressValue();

    public static final class Builder {
        private String zzaxl;
        private Long zzaKN;
        private Long zzaKO;
        private BitmapTeleporter zzaKP;
        private Uri zzaKQ;

        public Builder setDescription(String description) {
            this.zzaxl = description;
            return this;
        }

        public Builder setPlayedTimeMillis(long playedTimeMillis) {
            this.zzaKN = playedTimeMillis;
            return this;
        }

        public Builder setProgressValue(long progressValue) {
            this.zzaKO = progressValue;
            return this;
        }

        public Builder setCoverImage(Bitmap coverImage) {
            this.zzaKP = new BitmapTeleporter(coverImage);
            this.zzaKQ = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata metadata) {
            this.zzaxl = metadata.getDescription();
            this.zzaKN = metadata.getPlayedTime();
            this.zzaKO = metadata.getProgressValue();
            if (this.zzaKN == -1L) {
                this.zzaKN = null;
            }
            this.zzaKQ = metadata.getCoverImageUri();
            if (this.zzaKQ != null) {
                this.zzaKP = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChangeEntity(this.zzaxl, this.zzaKN, this.zzaKP, this.zzaKQ, this.zzaKO);
        }
    }
}

