/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.snapshot.SnapshotContents;
import com.google.android.gms.games.snapshot.SnapshotContentsEntityCreator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public final class SnapshotContentsEntity
extends AbstractSafeParcelable
implements SnapshotContents {
    private static final Object zzaRL = new Object();
    public static final SnapshotContentsEntityCreator CREATOR = new SnapshotContentsEntityCreator();
    private final int mVersionCode;
    private Contents zzaxB;

    public SnapshotContentsEntity(Contents contents) {
        this(1, contents);
    }

    SnapshotContentsEntity(int n, Contents contents) {
        this.mVersionCode = n;
        this.zzaxB = contents;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        zzaa.zza((!this.isClosed() ? 1 : 0) != 0, (Object)"Cannot mutate closed contents!");
        return this.zzaxB.getParcelFileDescriptor();
    }

    @Override
    public Contents zzvG() {
        return this.zzaxB;
    }

    @Override
    public void close() {
        this.zzaxB = null;
    }

    @Override
    public boolean isClosed() {
        return this.zzaxB == null;
    }

    @Override
    public byte[] readFully() throws IOException {
        zzaa.zza((!this.isClosed() ? 1 : 0) != 0, (Object)"Must provide a previously opened Snapshot");
        Object object = zzaRL;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor = this.zzaxB.getParcelFileDescriptor();
            FileInputStream fileInputStream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            try {
                fileInputStream.getChannel().position(0L);
                byte[] byArray = zzo.zza((InputStream)bufferedInputStream, (boolean)false);
                fileInputStream.getChannel().position(0L);
                return byArray;
            }
            catch (IOException iOException) {
                GamesLog.zzb("SnapshotContentsEntity", "Failed to read snapshot data", iOException);
                throw iOException;
            }
        }
    }

    @Override
    public boolean writeBytes(byte[] byArray) {
        return this.zza(0, byArray, 0, byArray.length, true);
    }

    @Override
    public boolean modifyBytes(int n, byte[] byArray, int n2, int n3) {
        return this.zza(n, byArray, n2, byArray.length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, byte[] byArray, int n2, int n3, boolean bl) {
        zzaa.zza((!this.isClosed() ? 1 : 0) != 0, (Object)"Must provide a previously opened SnapshotContents");
        Object object = zzaRL;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor = this.zzaxB.getParcelFileDescriptor();
            FileOutputStream fileOutputStream = new FileOutputStream(parcelFileDescriptor.getFileDescriptor());
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            try {
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.position(n);
                ((OutputStream)bufferedOutputStream).write(byArray, n2, n3);
                if (bl) {
                    fileChannel.truncate(byArray.length);
                }
                ((OutputStream)bufferedOutputStream).flush();
            }
            catch (IOException iOException) {
                GamesLog.zza("SnapshotContentsEntity", "Failed to write snapshot data", iOException);
                return false;
            }
            return true;
        }
    }

    public void writeToParcel(Parcel parcel, int n) {
        SnapshotContentsEntityCreator.zza(this, parcel, n);
    }
}

