/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.event;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.event.Event;
import com.google.android.gms.games.event.EventEntityCreator;

public final class EventEntity
extends AbstractSafeParcelable
implements Event {
    public static final EventEntityCreator CREATOR = new EventEntityCreator();
    private final int mVersionCode;
    private final String zzaKM;
    private final String mName;
    private final String zzVw;
    private final Uri zzaIU;
    private final String zzaJf;
    private final PlayerEntity zzaKi;
    private final long zzVv;
    private final String zzaKN;
    private final boolean zztv;

    public EventEntity(Event event) {
        this.mVersionCode = 1;
        this.zzaKM = event.getEventId();
        this.mName = event.getName();
        this.zzVw = event.getDescription();
        this.zzaIU = event.getIconImageUri();
        this.zzaJf = event.getIconImageUrl();
        this.zzaKi = (PlayerEntity)event.getPlayer().freeze();
        this.zzVv = event.getValue();
        this.zzaKN = event.getFormattedValue();
        this.zztv = event.isVisible();
    }

    EventEntity(int n, String string, String string2, String string3, Uri uri, String string4, Player player, long l, String string5, boolean bl) {
        this.mVersionCode = n;
        this.zzaKM = string;
        this.mName = string2;
        this.zzVw = string3;
        this.zzaIU = uri;
        this.zzaJf = string4;
        this.zzaKi = new PlayerEntity(player);
        this.zzVv = l;
        this.zzaKN = string5;
        this.zztv = bl;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getEventId() {
        return this.zzaKM;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.mName, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDescription() {
        return this.zzVw;
    }

    @Override
    public void getDescription(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzVw, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaIU;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaJf;
    }

    @Override
    public Player getPlayer() {
        return this.zzaKi;
    }

    @Override
    public long getValue() {
        return this.zzVv;
    }

    @Override
    public String getFormattedValue() {
        return this.zzaKN;
    }

    @Override
    public void getFormattedValue(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.zzaKN, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public boolean isVisible() {
        return this.zztv;
    }

    public Event freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return EventEntity.zza(this);
    }

    static int zza(Event event) {
        return zzz.hashCode((Object[])new Object[]{event.getEventId(), event.getName(), event.getDescription(), event.getIconImageUri(), event.getIconImageUrl(), event.getPlayer(), event.getValue(), event.getFormattedValue(), event.isVisible()});
    }

    public boolean equals(Object object) {
        return EventEntity.zza(this, object);
    }

    static boolean zza(Event event, Object object) {
        if (!(object instanceof Event)) {
            return false;
        }
        if (event == object) {
            return true;
        }
        Event event2 = (Event)object;
        return zzz.equal((Object)event2.getEventId(), (Object)event.getEventId()) && zzz.equal((Object)event2.getName(), (Object)event.getName()) && zzz.equal((Object)event2.getDescription(), (Object)event.getDescription()) && zzz.equal((Object)event2.getIconImageUri(), (Object)event.getIconImageUri()) && zzz.equal((Object)event2.getIconImageUrl(), (Object)event.getIconImageUrl()) && zzz.equal((Object)event2.getPlayer(), (Object)event.getPlayer()) && zzz.equal((Object)event2.getValue(), (Object)event.getValue()) && zzz.equal((Object)event2.getFormattedValue(), (Object)event.getFormattedValue()) && zzz.equal((Object)event2.isVisible(), (Object)event.isVisible());
    }

    public String toString() {
        return EventEntity.zzb(this);
    }

    static String zzb(Event event) {
        return zzz.zzy((Object)event).zzg("Id", (Object)event.getEventId()).zzg("Name", (Object)event.getName()).zzg("Description", (Object)event.getDescription()).zzg("IconImageUri", (Object)event.getIconImageUri()).zzg("IconImageUrl", (Object)event.getIconImageUrl()).zzg("Player", (Object)event.getPlayer()).zzg("Value", (Object)event.getValue()).zzg("FormattedValue", (Object)event.getFormattedValue()).zzg("isVisible", (Object)event.isVisible()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        EventEntityCreator.zza(this, parcel, n);
    }
}

