/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.GamesLog;
import java.lang.ref.WeakReference;

public class PopupManager {
    protected GamesClientImpl zzaMH;
    protected PopupLocationInfo zzaMI;

    public static PopupManager zza(GamesClientImpl gamesClientImpl, int n) {
        if (zzs.zzuY()) {
            return new PopupManagerHCMR1(gamesClientImpl, n);
        }
        return new PopupManager(gamesClientImpl, n);
    }

    private PopupManager(GamesClientImpl gamesClientImpl, int n) {
        this.zzaMH = gamesClientImpl;
        this.zzgR(n);
    }

    protected void zzgR(int n) {
        this.zzaMI = new PopupLocationInfo(n, (IBinder)new Binder());
    }

    public void setGravity(int n) {
        this.zzaMI.gravity = n;
    }

    public void zzs(View view) {
    }

    public void zzAB() {
        this.zzaMH.zza(this.zzaMI.zzaMJ, this.zzaMI.zzAA());
    }

    public Bundle zzAC() {
        return this.zzaMI.zzAA();
    }

    public IBinder zzAD() {
        return this.zzaMI.zzaMJ;
    }

    public PopupLocationInfo zzAE() {
        return this.zzaMI;
    }

    public static final class PopupLocationInfo {
        public IBinder zzaMJ;
        public int gravity;
        public int zzaMK = -1;
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;

        private PopupLocationInfo(int n, IBinder iBinder) {
            this.gravity = n;
            this.zzaMJ = iBinder;
        }

        public Bundle zzAA() {
            Bundle bundle = new Bundle();
            bundle.putInt("popupLocationInfo.gravity", this.gravity);
            bundle.putInt("popupLocationInfo.displayId", this.zzaMK);
            bundle.putInt("popupLocationInfo.left", this.left);
            bundle.putInt("popupLocationInfo.top", this.top);
            bundle.putInt("popupLocationInfo.right", this.right);
            bundle.putInt("popupLocationInfo.bottom", this.bottom);
            return bundle;
        }
    }

    @TargetApi(value=12)
    private static final class PopupManagerHCMR1
    extends PopupManager
    implements View.OnAttachStateChangeListener,
    ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<View> zzaML;
        private boolean zzaKV = false;

        protected PopupManagerHCMR1(GamesClientImpl gamesClientImpl, int n) {
            super(gamesClientImpl, n);
        }

        @Override
        protected void zzgR(int n) {
            this.zzaMI = new PopupLocationInfo(n, null);
        }

        @Override
        @TargetApi(value=16)
        public void zzs(View view) {
            Context context;
            View view2;
            this.zzaMH.zzAm();
            if (this.zzaML != null) {
                view2 = (View)this.zzaML.get();
                context = this.zzaMH.getContext();
                if (view2 == null && context instanceof Activity) {
                    view2 = ((Activity)context).getWindow().getDecorView();
                }
                if (view2 != null) {
                    view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewTreeObserver viewTreeObserver = view2.getViewTreeObserver();
                    if (zzs.zzvb()) {
                        viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            }
            this.zzaML = null;
            view2 = this.zzaMH.getContext();
            if (view == null && view2 instanceof Activity) {
                context = (Activity)view2;
                view = context.findViewById(0x1020002);
                if (view == null) {
                    view = ((Activity)view2).getWindow().getDecorView();
                }
                GamesLog.zzD("PopupManager", "You have not specified a View to use as content view for popups. Falling back to the Activity content view. Note that this may not work as expected in multi-screen environments");
            }
            if (view != null) {
                this.zzt(view);
                this.zzaML = new WeakReference<View>(view);
                view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                context = view.getViewTreeObserver();
                context.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                GamesLog.zzE("PopupManager", "No content view usable to display popups. Popups will not be displayed in response to this client's calls. Use setViewForPopups() to set your content view.");
            }
        }

        @Override
        public void zzAB() {
            if (this.zzaMI.zzaMJ != null) {
                super.zzAB();
                return;
            }
            this.zzaKV = this.zzaML != null;
        }

        public void onViewAttachedToWindow(View view) {
            this.zzt(view);
        }

        public void onViewDetachedFromWindow(View view) {
            this.zzaMH.zzAm();
            view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onGlobalLayout() {
            if (this.zzaML == null) {
                return;
            }
            View view = (View)this.zzaML.get();
            if (view == null) {
                return;
            }
            this.zzt(view);
        }

        @TargetApi(value=17)
        private void zzt(View view) {
            Display display;
            int n = -1;
            if (zzs.zzvc()) {
                display = view.getDisplay();
                n = display != null ? display.getDisplayId() : -1;
            }
            display = view.getWindowToken();
            int[] nArray = new int[2];
            view.getLocationInWindow(nArray);
            int n2 = view.getWidth();
            int n3 = view.getHeight();
            this.zzaMI.zzaMK = n;
            this.zzaMI.zzaMJ = display;
            this.zzaMI.left = nArray[0];
            this.zzaMI.top = nArray[1];
            this.zzaMI.right = nArray[0] + n2;
            this.zzaMI.bottom = nArray[1] + n3;
            if (this.zzaKV) {
                this.zzAB();
                this.zzaKV = false;
            }
        }
    }
}

