/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoEntity;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int mVersionCode;
    private String nU;
    private String dH;
    private final Uri QE;
    private final Uri QF;
    private final long Ro;
    private final int Rp;
    private final long Rq;
    private final String QP;
    private final String QQ;
    private final String Fx;
    private final MostRecentGameInfoEntity Rr;
    private final PlayerLevelInfo Rs;
    private final boolean Rt;
    private final boolean Ru;
    private final String Rv;
    private final String mName;
    private final Uri Rw;
    private final String Rx;
    private final Uri Ry;
    private final String Rz;
    private final int RA;
    private final long RB;
    private final boolean zzcqf;

    public PlayerEntity(Player player) {
        this(player, true);
    }

    public PlayerEntity(Player player, boolean bl) {
        this.mVersionCode = 14;
        this.nU = bl ? player.getPlayerId() : null;
        this.dH = player.getDisplayName();
        this.QE = player.getIconImageUri();
        this.QP = player.getIconImageUrl();
        this.QF = player.getHiResImageUri();
        this.QQ = player.getHiResImageUrl();
        this.Ro = player.getRetrievedTimestamp();
        this.Rp = player.zzbgf();
        this.Rq = player.getLastPlayedWithTimestamp();
        this.Fx = player.getTitle();
        this.Rt = player.zzbgg();
        MostRecentGameInfo mostRecentGameInfo = player.zzbgh();
        this.Rr = mostRecentGameInfo == null ? null : new MostRecentGameInfoEntity(mostRecentGameInfo);
        this.Rs = player.getLevelInfo();
        this.Ru = player.zzbge();
        this.Rv = player.zzbgd();
        this.mName = player.getName();
        this.Rw = player.getBannerImageLandscapeUri();
        this.Rx = player.getBannerImageLandscapeUrl();
        this.Ry = player.getBannerImagePortraitUri();
        this.Rz = player.getBannerImagePortraitUrl();
        this.RA = player.zzbgi();
        this.RB = player.zzbgj();
        this.zzcqf = player.isMuted();
        if (bl) {
            zzb.zzw((Object)this.nU);
        }
        zzb.zzw((Object)this.dH);
        zzb.zzbm((this.Ro > 0L ? 1 : 0) != 0);
    }

    PlayerEntity(int n, String string, String string2, Uri uri, Uri uri2, long l, int n2, long l2, String string3, String string4, String string5, MostRecentGameInfoEntity mostRecentGameInfoEntity, PlayerLevelInfo playerLevelInfo, boolean bl, boolean bl2, String string6, String string7, Uri uri3, String string8, Uri uri4, String string9, int n3, long l3, boolean bl3) {
        this.mVersionCode = n;
        this.nU = string;
        this.dH = string2;
        this.QE = uri;
        this.QP = string3;
        this.QF = uri2;
        this.QQ = string4;
        this.Ro = l;
        this.Rp = n2;
        this.Rq = l2;
        this.Fx = string5;
        this.Rt = bl;
        this.Rr = mostRecentGameInfoEntity;
        this.Rs = playerLevelInfo;
        this.Ru = bl2;
        this.Rv = string6;
        this.mName = string7;
        this.Rw = uri3;
        this.Rx = string8;
        this.Ry = uri4;
        this.Rz = string9;
        this.RA = n3;
        this.RB = l3;
        this.zzcqf = bl3;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getPlayerId() {
        return this.nU;
    }

    @Override
    public String getDisplayName() {
        return this.dH;
    }

    @Override
    public void getDisplayName(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.dH, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String zzbgd() {
        return this.Rv;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean zzbge() {
        return this.Ru;
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.QE;
    }

    @Override
    public String getIconImageUrl() {
        return this.QP;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.QF;
    }

    @Override
    public String getHiResImageUrl() {
        return this.QQ;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.Ro;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.Rq;
    }

    @Override
    public int zzbgf() {
        return this.Rp;
    }

    @Override
    public boolean zzbgg() {
        return this.Rt;
    }

    @Override
    public String getTitle() {
        return this.Fx;
    }

    @Override
    public void getTitle(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.Fx, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.Rs;
    }

    @Override
    public MostRecentGameInfo zzbgh() {
        return this.Rr;
    }

    @Override
    public Uri getBannerImageLandscapeUri() {
        return this.Rw;
    }

    @Override
    public String getBannerImageLandscapeUrl() {
        return this.Rx;
    }

    @Override
    public Uri getBannerImagePortraitUri() {
        return this.Ry;
    }

    @Override
    public String getBannerImagePortraitUrl() {
        return this.Rz;
    }

    @Override
    public int zzbgi() {
        return this.RA;
    }

    @Override
    public long zzbgj() {
        return this.RB;
    }

    @Override
    public boolean isMuted() {
        return this.zzcqf;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    static int zzb(Player player) {
        return zzaa.hashCode((Object[])new Object[]{player.getPlayerId(), player.getDisplayName(), player.zzbge(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp(), player.getTitle(), player.getLevelInfo(), player.zzbgd(), player.getName(), player.getBannerImageLandscapeUri(), player.getBannerImagePortraitUri(), player.zzbgi(), player.zzbgj(), player.isMuted()});
    }

    public boolean equals(Object object) {
        return PlayerEntity.zza(this, object);
    }

    static boolean zza(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return zzaa.equal((Object)player2.getPlayerId(), (Object)player.getPlayerId()) && zzaa.equal((Object)player2.getDisplayName(), (Object)player.getDisplayName()) && zzaa.equal((Object)player2.zzbge(), (Object)player.zzbge()) && zzaa.equal((Object)player2.getIconImageUri(), (Object)player.getIconImageUri()) && zzaa.equal((Object)player2.getHiResImageUri(), (Object)player.getHiResImageUri()) && zzaa.equal((Object)player2.getRetrievedTimestamp(), (Object)player.getRetrievedTimestamp()) && zzaa.equal((Object)player2.getTitle(), (Object)player.getTitle()) && zzaa.equal((Object)player2.getLevelInfo(), (Object)player.getLevelInfo()) && zzaa.equal((Object)player2.zzbgd(), (Object)player.zzbgd()) && zzaa.equal((Object)player2.getName(), (Object)player.getName()) && zzaa.equal((Object)player2.getBannerImageLandscapeUri(), (Object)player.getBannerImageLandscapeUri()) && zzaa.equal((Object)player2.getBannerImagePortraitUri(), (Object)player.getBannerImagePortraitUri()) && zzaa.equal((Object)player2.zzbgi(), (Object)player.zzbgi()) && zzaa.equal((Object)player2.zzbgj(), (Object)player.zzbgj()) && zzaa.equal((Object)player2.isMuted(), (Object)player.isMuted());
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    static String zzc(Player player) {
        return zzaa.zzz((Object)player).zzg("PlayerId", (Object)player.getPlayerId()).zzg("DisplayName", (Object)player.getDisplayName()).zzg("HasDebugAccess", (Object)player.zzbge()).zzg("IconImageUri", (Object)player.getIconImageUri()).zzg("IconImageUrl", (Object)player.getIconImageUrl()).zzg("HiResImageUri", (Object)player.getHiResImageUri()).zzg("HiResImageUrl", (Object)player.getHiResImageUrl()).zzg("RetrievedTimestamp", (Object)player.getRetrievedTimestamp()).zzg("Title", (Object)player.getTitle()).zzg("LevelInfo", (Object)player.getLevelInfo()).zzg("GamerTag", (Object)player.zzbgd()).zzg("Name", (Object)player.getName()).zzg("BannerImageLandscapeUri", (Object)player.getBannerImageLandscapeUri()).zzg("BannerImageLandscapeUrl", (Object)player.getBannerImageLandscapeUrl()).zzg("BannerImagePortraitUri", (Object)player.getBannerImagePortraitUri()).zzg("BannerImagePortraitUrl", (Object)player.getBannerImagePortraitUrl()).zzg("GamerFriendStatus", (Object)player.zzbgi()).zzg("GamerFriendUpdateTimestamp", (Object)player.zzbgj()).zzg("IsMuted", (Object)player.isMuted()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzasq()) {
            PlayerEntityCreator.zza(this, parcel, n);
        } else {
            parcel.writeString(this.nU);
            parcel.writeString(this.dH);
            parcel.writeString(this.QE == null ? null : this.QE.toString());
            parcel.writeString(this.QF == null ? null : this.QF.toString());
            parcel.writeLong(this.Ro);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity zzku(Parcel parcel) {
            boolean bl = PlayerEntity.zzf(PlayerEntity.zzasp());
            if (bl || PlayerEntity.zzhl((String)PlayerEntity.class.getCanonicalName())) {
                return super.zzku(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l = parcel.readLong();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            int n = -1;
            long l2 = -1L;
            Object var16_14 = null;
            Object var17_15 = null;
            Object var18_16 = null;
            Object var19_17 = null;
            Object var20_18 = null;
            boolean bl2 = true;
            boolean bl3 = false;
            Object var23_21 = null;
            Object var24_22 = null;
            Object var25_23 = null;
            Object var26_24 = null;
            int n2 = -1;
            long l3 = -1L;
            boolean bl4 = false;
            return new PlayerEntity(14, string, string2, uri, uri2, l, -1, -1L, null, null, null, null, null, true, false, string5, string6, null, null, null, null, -1, -1L, false);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzku(parcel);
        }
    }
}

