/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.util.zzg;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long XQ;
    private final String XR;
    private final String XS;
    private final long XT;
    private final long XU;
    private final String XV;
    private final Uri XW;
    private final Uri XX;
    private final PlayerEntity XY;
    private final String XZ;
    private final String Ya;
    private final String Yb;

    public LeaderboardScoreEntity(LeaderboardScore leaderboardScore) {
        this.XQ = leaderboardScore.getRank();
        this.XR = (String)zzab.zzaa((Object)leaderboardScore.getDisplayRank());
        this.XS = (String)zzab.zzaa((Object)leaderboardScore.getDisplayScore());
        this.XT = leaderboardScore.getRawScore();
        this.XU = leaderboardScore.getTimestampMillis();
        this.XV = leaderboardScore.getScoreHolderDisplayName();
        this.XW = leaderboardScore.getScoreHolderIconImageUri();
        this.XX = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.XY = player == null ? null : (PlayerEntity)player.freeze();
        this.XZ = leaderboardScore.getScoreTag();
        this.Ya = leaderboardScore.getScoreHolderIconImageUrl();
        this.Yb = leaderboardScore.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.XQ;
    }

    @Override
    public String getDisplayRank() {
        return this.XR;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.XR, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public String getDisplayScore() {
        return this.XS;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer charArrayBuffer) {
        zzg.zzb((String)this.XS, (CharArrayBuffer)charArrayBuffer);
    }

    @Override
    public long getRawScore() {
        return this.XT;
    }

    @Override
    public long getTimestampMillis() {
        return this.XU;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.XY == null) {
            return this.XV;
        }
        return this.XY.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer charArrayBuffer) {
        if (this.XY == null) {
            zzg.zzb((String)this.XV, (CharArrayBuffer)charArrayBuffer);
            return;
        }
        this.XY.getDisplayName(charArrayBuffer);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.XY == null) {
            return this.XW;
        }
        return this.XY.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.XY == null) {
            return this.Ya;
        }
        return this.XY.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.XY == null) {
            return this.XX;
        }
        return this.XY.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.XY == null) {
            return this.Yb;
        }
        return this.XY.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.XY;
    }

    @Override
    public String getScoreTag() {
        return this.XZ;
    }

    public LeaderboardScore zzblb() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzaa.hashCode((Object[])new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public boolean equals(Object object) {
        return LeaderboardScoreEntity.zza(this, object);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzaa.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzaa.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzaa.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzaa.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzaa.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzaa.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzaa.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzaa.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzaa.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzaa.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzaa.zzz((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzblb();
    }
}

