/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int mVersionCode;
    private final GameEntity WG;
    private final String bT;
    private final long Yq;
    private final int Yr;
    private final ParticipantEntity Ys;
    private final ArrayList<ParticipantEntity> Yt;
    private final int Yu;
    private final int Yv;

    InvitationEntity(Invitation invitation) {
        this.mVersionCode = 2;
        this.WG = new GameEntity(invitation.getGame());
        this.bT = invitation.getInvitationId();
        this.Yq = invitation.getCreationTimestamp();
        this.Yr = invitation.getInvitationType();
        this.Yu = invitation.getVariant();
        this.Yv = invitation.getAvailableAutoMatchSlots();
        String string = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.Yt = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string)) {
                participant = participant2;
            }
            this.Yt.add((ParticipantEntity)participant2.freeze());
        }
        zzab.zzb(participant, (Object)"Must have a valid inviter!");
        this.Ys = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int n, GameEntity gameEntity, String string, long l, int n2, ParticipantEntity participantEntity, ArrayList<ParticipantEntity> arrayList, int n3, int n4) {
        this.mVersionCode = n;
        this.WG = gameEntity;
        this.bT = string;
        this.Yq = l;
        this.Yr = n2;
        this.Ys = participantEntity;
        this.Yt = arrayList;
        this.Yu = n3;
        this.Yv = n4;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.WG;
    }

    @Override
    public String getInvitationId() {
        return this.bT;
    }

    @Override
    public Participant getInviter() {
        return this.Ys;
    }

    @Override
    public long getCreationTimestamp() {
        return this.Yq;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.Yt);
    }

    @Override
    public int getInvitationType() {
        return this.Yr;
    }

    @Override
    public int getVariant() {
        return this.Yu;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.Yv;
    }

    public Invitation freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return zzaa.hashCode((Object[])new Object[]{invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots()});
    }

    public boolean equals(Object object) {
        return InvitationEntity.zza(this, object);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzaa.equal((Object)invitation2.getGame(), (Object)invitation.getGame()) && zzaa.equal((Object)invitation2.getInvitationId(), (Object)invitation.getInvitationId()) && zzaa.equal((Object)invitation2.getCreationTimestamp(), (Object)invitation.getCreationTimestamp()) && zzaa.equal((Object)invitation2.getInvitationType(), (Object)invitation.getInvitationType()) && zzaa.equal((Object)invitation2.getInviter(), (Object)invitation.getInviter()) && zzaa.equal((Object)invitation2.getParticipants(), (Object)invitation.getParticipants()) && zzaa.equal((Object)invitation2.getVariant(), (Object)invitation.getVariant()) && zzaa.equal((Object)invitation2.getAvailableAutoMatchSlots(), (Object)invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzaa.zzz((Object)invitation).zzg("Game", (Object)invitation.getGame()).zzg("InvitationId", (Object)invitation.getInvitationId()).zzg("CreationTimestamp", (Object)invitation.getCreationTimestamp()).zzg("InvitationType", (Object)invitation.getInvitationType()).zzg("Inviter", (Object)invitation.getInviter()).zzg("Participants", (Object)invitation.getParticipants()).zzg("Variant", (Object)invitation.getVariant()).zzg("AvailableAutoMatchSlots", (Object)invitation.getAvailableAutoMatchSlots()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (!this.zzasq()) {
            InvitationEntityCreator.zza(this, parcel, n);
        } else {
            this.WG.writeToParcel(parcel, n);
            parcel.writeString(this.bT);
            parcel.writeLong(this.Yq);
            parcel.writeInt(this.Yr);
            this.Ys.writeToParcel(parcel, n);
            int n2 = this.Yt.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                this.Yt.get(i).writeToParcel(parcel, n);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity zzln(Parcel parcel) {
            int n;
            boolean bl = InvitationEntity.zzf(InvitationEntity.zzasp());
            if (bl || InvitationEntity.zzhl((String)InvitationEntity.class.getCanonicalName())) {
                return super.zzln(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (n = 0; n < n3; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            boolean bl2 = false;
            return new InvitationEntity(2, gameEntity, string, l, n2, participantEntity, arrayList, -1, 0);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.zzln(parcel);
        }
    }
}

