/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomConfigImpl;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class RoomConfig {
    protected RoomConfig() {
    }

    public abstract RoomUpdateListener getRoomUpdateListener();

    public abstract String getInvitationId();

    public abstract RoomStatusUpdateListener getRoomStatusUpdateListener();

    public abstract RealTimeMessageReceivedListener getMessageReceivedListener();

    public abstract int getVariant();

    public abstract String[] getInvitedPlayerIds();

    public abstract Bundle getAutoMatchCriteria();

    public static Builder builder(RoomUpdateListener roomUpdateListener) {
        return new Builder(roomUpdateListener);
    }

    public static Bundle createAutoMatchCriteria(int n, int n2, long l) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", n);
        bundle.putInt("max_automatch_players", n2);
        bundle.putLong("exclusive_bit_mask", l);
        return bundle;
    }

    public static final class Builder {
        final RoomUpdateListener YF;
        RoomStatusUpdateListener YG;
        RealTimeMessageReceivedListener YH;
        String YI = null;
        int Yu = -1;
        ArrayList<String> YJ = new ArrayList();
        Bundle YK;

        private Builder(RoomUpdateListener roomUpdateListener) {
            this.YF = (RoomUpdateListener)zzab.zzb((Object)roomUpdateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String string) {
            zzab.zzaa((Object)string);
            this.YI = string;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener roomStatusUpdateListener) {
            this.YG = roomStatusUpdateListener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            this.YH = realTimeMessageReceivedListener;
            return this;
        }

        public Builder addPlayersToInvite(String ... stringArray) {
            zzab.zzaa((Object)stringArray);
            this.YJ.addAll(Arrays.asList(stringArray));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> arrayList) {
            zzab.zzaa(arrayList);
            this.YJ.addAll(arrayList);
            return this;
        }

        public Builder setVariant(int n) {
            zzab.zzb((n == -1 || n > 0 ? 1 : 0) != 0, (Object)"Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.Yu = n;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle bundle) {
            this.YK = bundle;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfigImpl(this);
        }
    }
}

