/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.video;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.games.video.VideoConfigurationCreator;

public final class VideoConfiguration
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<VideoConfiguration> CREATOR = new VideoConfigurationCreator();
    public static final int QUALITY_LEVEL_FULLHD = 3;
    public static final int QUALITY_LEVEL_XHD = 2;
    public static final int QUALITY_LEVEL_HD = 1;
    public static final int QUALITY_LEVEL_SD = 0;
    public static final int QUALITY_LEVEL_UNKNOWN = -1;
    public static final int NUM_QUALITY_LEVEL = 4;
    public static final int CAPTURE_MODE_UNKNOWN = -1;
    public static final int CAPTURE_MODE_FILE = 0;
    public static final int CAPTURE_MODE_STREAM = 1;
    public static final int NUM_CAPTURE_MODE = 2;
    private final int mVersionCode;
    private final int aaj;
    private final int aac;
    private final String aak;
    private final String aal;
    private final String aam;
    private final String aan;
    private final boolean aao;

    private VideoConfiguration(int n, int n2, String string, String string2, String string3, String string4, boolean bl) {
        this(2, n, n2, string, string2, string3, string4, bl);
    }

    public VideoConfiguration(int n, int n2, int n3, String string, String string2, String string3, String string4, boolean bl) {
        this.mVersionCode = n;
        zzab.zzbn((boolean)VideoConfiguration.isValidQualityLevel(n2, false));
        zzab.zzbn((boolean)VideoConfiguration.isValidCaptureMode(n3, false));
        this.aaj = n2;
        this.aac = n3;
        this.aao = bl;
        if (n3 == 1) {
            this.aal = string2;
            this.aak = string;
            this.aam = string3;
            this.aan = string4;
        } else {
            zzab.zzb((string2 == null ? 1 : 0) != 0, (Object)"Stream key should be null when not streaming");
            zzab.zzb((string == null ? 1 : 0) != 0, (Object)"Stream url should be null when not streaming");
            zzab.zzb((string3 == null ? 1 : 0) != 0, (Object)"Stream title should be null when not streaming");
            zzab.zzb((string4 == null ? 1 : 0) != 0, (Object)"Stream description should be null when not streaming");
            this.aal = null;
            this.aak = null;
            this.aam = null;
            this.aan = null;
        }
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int getQualityLevel() {
        return this.aaj;
    }

    public int getCaptureMode() {
        return this.aac;
    }

    public String zzblt() {
        return this.aal;
    }

    public String getStreamUrl() {
        return this.aak;
    }

    public String zzblu() {
        return this.aam;
    }

    public String zzblv() {
        return this.aan;
    }

    public boolean zzblw() {
        return this.aao;
    }

    public void writeToParcel(Parcel parcel, int n) {
        VideoConfigurationCreator.zza(this, parcel, n);
    }

    public static boolean isValidQualityLevel(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidCaptureMode(int n, boolean bl) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
            case -1: {
                return bl;
            }
        }
        return false;
    }

    public static final class Builder {
        private int aaj;
        private int aac;
        private boolean aao;
        private String aak;
        private String aal;
        private String aam;
        private String aan;

        public Builder(int n, int n2) {
            this.aaj = n;
            this.aac = n2;
            this.aao = true;
            this.aak = null;
            this.aal = null;
            this.aam = null;
            this.aan = null;
        }

        public Builder setQualityLevel(int n) {
            this.aaj = n;
            return this;
        }

        public Builder setCaptureMode(int n) {
            this.aac = n;
            return this;
        }

        public VideoConfiguration build() {
            return new VideoConfiguration(this.aaj, this.aac, null, null, null, null, this.aao);
        }
    }
}

